package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetLogHistogram invokes the emr.GetLogHistogram API synchronously
// api document: https://help.aliyun.com/api/emr/getloghistogram.html
func (client *Client) GetLogHistogram(request *GetLogHistogramRequest) (response *GetLogHistogramResponse, err error) {
	response = CreateGetLogHistogramResponse()
	err = client.DoAction(request, response)
	return
}

// GetLogHistogramWithChan invokes the emr.GetLogHistogram API asynchronously
// api document: https://help.aliyun.com/api/emr/getloghistogram.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetLogHistogramWithChan(request *GetLogHistogramRequest) (<-chan *GetLogHistogramResponse, <-chan error) {
	responseChan := make(chan *GetLogHistogramResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetLogHistogram(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetLogHistogramWithCallback invokes the emr.GetLogHistogram API asynchronously
// api document: https://help.aliyun.com/api/emr/getloghistogram.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetLogHistogramWithCallback(request *GetLogHistogramRequest, callback func(response *GetLogHistogramResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetLogHistogramResponse
		var err error
		defer close(result)
		response, err = client.GetLogHistogram(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetLogHistogramRequest is the request struct for api GetLogHistogram
type GetLogHistogramRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	HostInnerIp     string           `position:"Query" name:"HostInnerIp"`
	HostName        string           `position:"Query" name:"HostName"`
	LogstoreName    string           `position:"Query" name:"LogstoreName"`
	FromTimestamp   requests.Integer `position:"Query" name:"FromTimestamp"`
	ToTimestamp     requests.Integer `position:"Query" name:"ToTimestamp"`
	SlsQueryString  string           `position:"Query" name:"SlsQueryString"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
}

// GetLogHistogramResponse is the response struct for api GetLogHistogram
type GetLogHistogramResponse struct {
	*responses.BaseResponse
	RequestId           string              `json:"RequestId" xml:"RequestId"`
	Completed           bool                `json:"Completed" xml:"Completed"`
	TotalCount          int                 `json:"TotalCount" xml:"TotalCount"`
	SlsLogHistogramList SlsLogHistogramList `json:"SlsLogHistogramList" xml:"SlsLogHistogramList"`
}

// CreateGetLogHistogramRequest creates a request to invoke GetLogHistogram API
func CreateGetLogHistogramRequest() (request *GetLogHistogramRequest) {
	request = &GetLogHistogramRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "GetLogHistogram", "emr", "openAPI")
	return
}

// CreateGetLogHistogramResponse creates a response to parse from GetLogHistogram response
func CreateGetLogHistogramResponse() (response *GetLogHistogramResponse) {
	response = &GetLogHistogramResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
