package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListClusterOperation invokes the emr.ListClusterOperation API synchronously
// api document: https://help.aliyun.com/api/emr/listclusteroperation.html
func (client *Client) ListClusterOperation(request *ListClusterOperationRequest) (response *ListClusterOperationResponse, err error) {
	response = CreateListClusterOperationResponse()
	err = client.DoAction(request, response)
	return
}

// ListClusterOperationWithChan invokes the emr.ListClusterOperation API asynchronously
// api document: https://help.aliyun.com/api/emr/listclusteroperation.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListClusterOperationWithChan(request *ListClusterOperationRequest) (<-chan *ListClusterOperationResponse, <-chan error) {
	responseChan := make(chan *ListClusterOperationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListClusterOperation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListClusterOperationWithCallback invokes the emr.ListClusterOperation API asynchronously
// api document: https://help.aliyun.com/api/emr/listclusteroperation.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListClusterOperationWithCallback(request *ListClusterOperationRequest, callback func(response *ListClusterOperationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListClusterOperationResponse
		var err error
		defer close(result)
		response, err = client.ListClusterOperation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListClusterOperationRequest is the request struct for api ListClusterOperation
type ListClusterOperationRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	ServiceName     string           `position:"Query" name:"ServiceName"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	Status          string           `position:"Query" name:"Status"`
}

// ListClusterOperationResponse is the response struct for api ListClusterOperation
type ListClusterOperationResponse struct {
	*responses.BaseResponse
	RequestId            string               `json:"RequestId" xml:"RequestId"`
	TotalCount           int                  `json:"TotalCount" xml:"TotalCount"`
	PageNumber           int                  `json:"PageNumber" xml:"PageNumber"`
	PageSize             int                  `json:"PageSize" xml:"PageSize"`
	ClusterOperationList ClusterOperationList `json:"ClusterOperationList" xml:"ClusterOperationList"`
}

// CreateListClusterOperationRequest creates a request to invoke ListClusterOperation API
func CreateListClusterOperationRequest() (request *ListClusterOperationRequest) {
	request = &ListClusterOperationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListClusterOperation", "emr", "openAPI")
	return
}

// CreateListClusterOperationResponse creates a response to parse from ListClusterOperation response
func CreateListClusterOperationResponse() (response *ListClusterOperationResponse) {
	response = &ListClusterOperationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
