package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDependedService invokes the emr.ListDependedService API synchronously
// api document: https://help.aliyun.com/api/emr/listdependedservice.html
func (client *Client) ListDependedService(request *ListDependedServiceRequest) (response *ListDependedServiceResponse, err error) {
	response = CreateListDependedServiceResponse()
	err = client.DoAction(request, response)
	return
}

// ListDependedServiceWithChan invokes the emr.ListDependedService API asynchronously
// api document: https://help.aliyun.com/api/emr/listdependedservice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListDependedServiceWithChan(request *ListDependedServiceRequest) (<-chan *ListDependedServiceResponse, <-chan error) {
	responseChan := make(chan *ListDependedServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDependedService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDependedServiceWithCallback invokes the emr.ListDependedService API asynchronously
// api document: https://help.aliyun.com/api/emr/listdependedservice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListDependedServiceWithCallback(request *ListDependedServiceRequest, callback func(response *ListDependedServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDependedServiceResponse
		var err error
		defer close(result)
		response, err = client.ListDependedService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDependedServiceRequest is the request struct for api ListDependedService
type ListDependedServiceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ServiceName     string           `position:"Query" name:"ServiceName"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
}

// ListDependedServiceResponse is the response struct for api ListDependedService
type ListDependedServiceResponse struct {
	*responses.BaseResponse
	RequestId     string                           `json:"RequestId" xml:"RequestId"`
	ExistServices bool                             `json:"ExistServices" xml:"ExistServices"`
	ServiceList   ServiceListInListDependedService `json:"ServiceList" xml:"ServiceList"`
}

// CreateListDependedServiceRequest creates a request to invoke ListDependedService API
func CreateListDependedServiceRequest() (request *ListDependedServiceRequest) {
	request = &ListDependedServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListDependedService", "emr", "openAPI")
	return
}

// CreateListDependedServiceResponse creates a response to parse from ListDependedService response
func CreateListDependedServiceResponse() (response *ListDependedServiceResponse) {
	response = &ListDependedServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
