package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListJobExecutionPlanHierarchy invokes the emr.ListJobExecutionPlanHierarchy API synchronously
// api document: https://help.aliyun.com/api/emr/listjobexecutionplanhierarchy.html
func (client *Client) ListJobExecutionPlanHierarchy(request *ListJobExecutionPlanHierarchyRequest) (response *ListJobExecutionPlanHierarchyResponse, err error) {
	response = CreateListJobExecutionPlanHierarchyResponse()
	err = client.DoAction(request, response)
	return
}

// ListJobExecutionPlanHierarchyWithChan invokes the emr.ListJobExecutionPlanHierarchy API asynchronously
// api document: https://help.aliyun.com/api/emr/listjobexecutionplanhierarchy.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListJobExecutionPlanHierarchyWithChan(request *ListJobExecutionPlanHierarchyRequest) (<-chan *ListJobExecutionPlanHierarchyResponse, <-chan error) {
	responseChan := make(chan *ListJobExecutionPlanHierarchyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListJobExecutionPlanHierarchy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListJobExecutionPlanHierarchyWithCallback invokes the emr.ListJobExecutionPlanHierarchy API asynchronously
// api document: https://help.aliyun.com/api/emr/listjobexecutionplanhierarchy.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListJobExecutionPlanHierarchyWithCallback(request *ListJobExecutionPlanHierarchyRequest, callback func(response *ListJobExecutionPlanHierarchyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListJobExecutionPlanHierarchyResponse
		var err error
		defer close(result)
		response, err = client.ListJobExecutionPlanHierarchy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListJobExecutionPlanHierarchyRequest is the request struct for api ListJobExecutionPlanHierarchy
type ListJobExecutionPlanHierarchyRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	CurrentId       requests.Integer `position:"Query" name:"CurrentId"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
}

// ListJobExecutionPlanHierarchyResponse is the response struct for api ListJobExecutionPlanHierarchy
type ListJobExecutionPlanHierarchyResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	Success        string         `json:"Success" xml:"Success"`
	ErrCode        string         `json:"ErrCode" xml:"ErrCode"`
	ErrMsg         string         `json:"ErrMsg" xml:"ErrMsg"`
	TotalCount     int            `json:"TotalCount" xml:"TotalCount"`
	PageSize       int            `json:"pageSize" xml:"pageSize"`
	PageNumber     int            `json:"pageNumber" xml:"pageNumber"`
	HierarchyInfos HierarchyInfos `json:"HierarchyInfos" xml:"HierarchyInfos"`
}

// CreateListJobExecutionPlanHierarchyRequest creates a request to invoke ListJobExecutionPlanHierarchy API
func CreateListJobExecutionPlanHierarchyRequest() (request *ListJobExecutionPlanHierarchyRequest) {
	request = &ListJobExecutionPlanHierarchyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListJobExecutionPlanHierarchy", "emr", "openAPI")
	return
}

// CreateListJobExecutionPlanHierarchyResponse creates a response to parse from ListJobExecutionPlanHierarchy response
func CreateListJobExecutionPlanHierarchyResponse() (response *ListJobExecutionPlanHierarchyResponse) {
	response = &ListJobExecutionPlanHierarchyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
