package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListOpsOperation invokes the emr.ListOpsOperation API synchronously
// api document: https://help.aliyun.com/api/emr/listopsoperation.html
func (client *Client) ListOpsOperation(request *ListOpsOperationRequest) (response *ListOpsOperationResponse, err error) {
	response = CreateListOpsOperationResponse()
	err = client.DoAction(request, response)
	return
}

// ListOpsOperationWithChan invokes the emr.ListOpsOperation API asynchronously
// api document: https://help.aliyun.com/api/emr/listopsoperation.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListOpsOperationWithChan(request *ListOpsOperationRequest) (<-chan *ListOpsOperationResponse, <-chan error) {
	responseChan := make(chan *ListOpsOperationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListOpsOperation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListOpsOperationWithCallback invokes the emr.ListOpsOperation API asynchronously
// api document: https://help.aliyun.com/api/emr/listopsoperation.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListOpsOperationWithCallback(request *ListOpsOperationRequest, callback func(response *ListOpsOperationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListOpsOperationResponse
		var err error
		defer close(result)
		response, err = client.ListOpsOperation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListOpsOperationRequest is the request struct for api ListOpsOperation
type ListOpsOperationRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
}

// ListOpsOperationResponse is the response struct for api ListOpsOperation
type ListOpsOperationResponse struct {
	*responses.BaseResponse
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	Total            int              `json:"Total" xml:"Total"`
	PageNumber       int              `json:"PageNumber" xml:"PageNumber"`
	PageSize         int              `json:"PageSize" xml:"PageSize"`
	OpsOperationList OpsOperationList `json:"OpsOperationList" xml:"OpsOperationList"`
}

// CreateListOpsOperationRequest creates a request to invoke ListOpsOperation API
func CreateListOpsOperationRequest() (request *ListOpsOperationRequest) {
	request = &ListOpsOperationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListOpsOperation", "emr", "openAPI")
	return
}

// CreateListOpsOperationResponse creates a response to parse from ListOpsOperation response
func CreateListOpsOperationResponse() (response *ListOpsOperationResponse) {
	response = &ListOpsOperationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
