package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListScalingRule invokes the emr.ListScalingRule API synchronously
// api document: https://help.aliyun.com/api/emr/listscalingrule.html
func (client *Client) ListScalingRule(request *ListScalingRuleRequest) (response *ListScalingRuleResponse, err error) {
	response = CreateListScalingRuleResponse()
	err = client.DoAction(request, response)
	return
}

// ListScalingRuleWithChan invokes the emr.ListScalingRule API asynchronously
// api document: https://help.aliyun.com/api/emr/listscalingrule.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListScalingRuleWithChan(request *ListScalingRuleRequest) (<-chan *ListScalingRuleResponse, <-chan error) {
	responseChan := make(chan *ListScalingRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListScalingRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListScalingRuleWithCallback invokes the emr.ListScalingRule API asynchronously
// api document: https://help.aliyun.com/api/emr/listscalingrule.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListScalingRuleWithCallback(request *ListScalingRuleRequest, callback func(response *ListScalingRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListScalingRuleResponse
		var err error
		defer close(result)
		response, err = client.ListScalingRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListScalingRuleRequest is the request struct for api ListScalingRule
type ListScalingRuleRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	HostGroupId     string           `position:"Query" name:"HostGroupId"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
}

// ListScalingRuleResponse is the response struct for api ListScalingRule
type ListScalingRuleResponse struct {
	*responses.BaseResponse
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	PageNumber int      `json:"PageNumber" xml:"PageNumber"`
	PageSize   int      `json:"PageSize" xml:"PageSize"`
	Total      int      `json:"Total" xml:"Total"`
	RuleList   RuleList `json:"RuleList" xml:"RuleList"`
}

// CreateListScalingRuleRequest creates a request to invoke ListScalingRule API
func CreateListScalingRuleRequest() (request *ListScalingRuleRequest) {
	request = &ListScalingRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListScalingRule", "emr", "openAPI")
	return
}

// CreateListScalingRuleResponse creates a response to parse from ListScalingRule response
func CreateListScalingRuleResponse() (response *ListScalingRuleResponse) {
	response = &ListScalingRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
