package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MetastoreUpdateKafkaTopicBatch invokes the emr.MetastoreUpdateKafkaTopicBatch API synchronously
// api document: https://help.aliyun.com/api/emr/metastoreupdatekafkatopicbatch.html
func (client *Client) MetastoreUpdateKafkaTopicBatch(request *MetastoreUpdateKafkaTopicBatchRequest) (response *MetastoreUpdateKafkaTopicBatchResponse, err error) {
	response = CreateMetastoreUpdateKafkaTopicBatchResponse()
	err = client.DoAction(request, response)
	return
}

// MetastoreUpdateKafkaTopicBatchWithChan invokes the emr.MetastoreUpdateKafkaTopicBatch API asynchronously
// api document: https://help.aliyun.com/api/emr/metastoreupdatekafkatopicbatch.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MetastoreUpdateKafkaTopicBatchWithChan(request *MetastoreUpdateKafkaTopicBatchRequest) (<-chan *MetastoreUpdateKafkaTopicBatchResponse, <-chan error) {
	responseChan := make(chan *MetastoreUpdateKafkaTopicBatchResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MetastoreUpdateKafkaTopicBatch(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MetastoreUpdateKafkaTopicBatchWithCallback invokes the emr.MetastoreUpdateKafkaTopicBatch API asynchronously
// api document: https://help.aliyun.com/api/emr/metastoreupdatekafkatopicbatch.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MetastoreUpdateKafkaTopicBatchWithCallback(request *MetastoreUpdateKafkaTopicBatchRequest, callback func(response *MetastoreUpdateKafkaTopicBatchResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MetastoreUpdateKafkaTopicBatchResponse
		var err error
		defer close(result)
		response, err = client.MetastoreUpdateKafkaTopicBatch(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MetastoreUpdateKafkaTopicBatchRequest is the request struct for api MetastoreUpdateKafkaTopicBatch
type MetastoreUpdateKafkaTopicBatchRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer                            `position:"Query" name:"ResourceOwnerId"`
	TopicParam      *[]MetastoreUpdateKafkaTopicBatchTopicParam `position:"Query" name:"TopicParam"  type:"Repeated"`
}

// MetastoreUpdateKafkaTopicBatchTopicParam is a repeated param struct in MetastoreUpdateKafkaTopicBatchRequest
type MetastoreUpdateKafkaTopicBatchTopicParam struct {
	TopicId       string `name:"TopicId"`
	NumPartitions string `name:"NumPartitions"`
}

// MetastoreUpdateKafkaTopicBatchResponse is the response struct for api MetastoreUpdateKafkaTopicBatch
type MetastoreUpdateKafkaTopicBatchResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	TaskId    string `json:"TaskId" xml:"TaskId"`
}

// CreateMetastoreUpdateKafkaTopicBatchRequest creates a request to invoke MetastoreUpdateKafkaTopicBatch API
func CreateMetastoreUpdateKafkaTopicBatchRequest() (request *MetastoreUpdateKafkaTopicBatchRequest) {
	request = &MetastoreUpdateKafkaTopicBatchRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "MetastoreUpdateKafkaTopicBatch", "emr", "openAPI")
	return
}

// CreateMetastoreUpdateKafkaTopicBatchResponse creates a response to parse from MetastoreUpdateKafkaTopicBatch response
func CreateMetastoreUpdateKafkaTopicBatchResponse() (response *MetastoreUpdateKafkaTopicBatchResponse) {
	response = &MetastoreUpdateKafkaTopicBatchResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
