package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MigrateClusterHostGroupHost invokes the emr.MigrateClusterHostGroupHost API synchronously
// api document: https://help.aliyun.com/api/emr/migrateclusterhostgrouphost.html
func (client *Client) MigrateClusterHostGroupHost(request *MigrateClusterHostGroupHostRequest) (response *MigrateClusterHostGroupHostResponse, err error) {
	response = CreateMigrateClusterHostGroupHostResponse()
	err = client.DoAction(request, response)
	return
}

// MigrateClusterHostGroupHostWithChan invokes the emr.MigrateClusterHostGroupHost API asynchronously
// api document: https://help.aliyun.com/api/emr/migrateclusterhostgrouphost.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MigrateClusterHostGroupHostWithChan(request *MigrateClusterHostGroupHostRequest) (<-chan *MigrateClusterHostGroupHostResponse, <-chan error) {
	responseChan := make(chan *MigrateClusterHostGroupHostResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MigrateClusterHostGroupHost(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MigrateClusterHostGroupHostWithCallback invokes the emr.MigrateClusterHostGroupHost API asynchronously
// api document: https://help.aliyun.com/api/emr/migrateclusterhostgrouphost.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MigrateClusterHostGroupHostWithCallback(request *MigrateClusterHostGroupHostRequest, callback func(response *MigrateClusterHostGroupHostResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MigrateClusterHostGroupHostResponse
		var err error
		defer close(result)
		response, err = client.MigrateClusterHostGroupHost(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MigrateClusterHostGroupHostRequest is the request struct for api MigrateClusterHostGroupHost
type MigrateClusterHostGroupHostRequest struct {
	*requests.RpcRequest
	HostInstanceIdList *[]string        `position:"Query" name:"HostInstanceIdList"  type:"Repeated"`
	ResourceOwnerId    requests.Integer `position:"Query" name:"ResourceOwnerId"`
	HostGroupId        string           `position:"Query" name:"HostGroupId"`
	ClusterId          string           `position:"Query" name:"ClusterId"`
}

// MigrateClusterHostGroupHostResponse is the response struct for api MigrateClusterHostGroupHost
type MigrateClusterHostGroupHostResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateMigrateClusterHostGroupHostRequest creates a request to invoke MigrateClusterHostGroupHost API
func CreateMigrateClusterHostGroupHostRequest() (request *MigrateClusterHostGroupHostRequest) {
	request = &MigrateClusterHostGroupHostRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "MigrateClusterHostGroupHost", "emr", "openAPI")
	return
}

// CreateMigrateClusterHostGroupHostResponse creates a response to parse from MigrateClusterHostGroupHost response
func CreateMigrateClusterHostGroupHostResponse() (response *MigrateClusterHostGroupHostResponse) {
	response = &MigrateClusterHostGroupHostResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
