package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyJobExecutionPlanParam invokes the emr.ModifyJobExecutionPlanParam API synchronously
// api document: https://help.aliyun.com/api/emr/modifyjobexecutionplanparam.html
func (client *Client) ModifyJobExecutionPlanParam(request *ModifyJobExecutionPlanParamRequest) (response *ModifyJobExecutionPlanParamResponse, err error) {
	response = CreateModifyJobExecutionPlanParamResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyJobExecutionPlanParamWithChan invokes the emr.ModifyJobExecutionPlanParam API asynchronously
// api document: https://help.aliyun.com/api/emr/modifyjobexecutionplanparam.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyJobExecutionPlanParamWithChan(request *ModifyJobExecutionPlanParamRequest) (<-chan *ModifyJobExecutionPlanParamResponse, <-chan error) {
	responseChan := make(chan *ModifyJobExecutionPlanParamResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyJobExecutionPlanParam(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyJobExecutionPlanParamWithCallback invokes the emr.ModifyJobExecutionPlanParam API asynchronously
// api document: https://help.aliyun.com/api/emr/modifyjobexecutionplanparam.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyJobExecutionPlanParamWithCallback(request *ModifyJobExecutionPlanParamRequest, callback func(response *ModifyJobExecutionPlanParamResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyJobExecutionPlanParamResponse
		var err error
		defer close(result)
		response, err = client.ModifyJobExecutionPlanParam(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyJobExecutionPlanParamRequest is the request struct for api ModifyJobExecutionPlanParam
type ModifyJobExecutionPlanParamRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ParamName       string           `position:"Query" name:"ParamName"`
	ParamValue      string           `position:"Query" name:"ParamValue"`
	Id              requests.Integer `position:"Query" name:"Id"`
}

// ModifyJobExecutionPlanParamResponse is the response struct for api ModifyJobExecutionPlanParam
type ModifyJobExecutionPlanParamResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   string `json:"Success" xml:"Success"`
	ErrCode   string `json:"ErrCode" xml:"ErrCode"`
	ErrMsg    string `json:"ErrMsg" xml:"ErrMsg"`
}

// CreateModifyJobExecutionPlanParamRequest creates a request to invoke ModifyJobExecutionPlanParam API
func CreateModifyJobExecutionPlanParamRequest() (request *ModifyJobExecutionPlanParamRequest) {
	request = &ModifyJobExecutionPlanParamRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ModifyJobExecutionPlanParam", "emr", "openAPI")
	return
}

// CreateModifyJobExecutionPlanParamResponse creates a response to parse from ModifyJobExecutionPlanParam response
func CreateModifyJobExecutionPlanParamResponse() (response *ModifyJobExecutionPlanParamResponse) {
	response = &ModifyJobExecutionPlanParamResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
