package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyUserStatistics invokes the emr.ModifyUserStatistics API synchronously
// api document: https://help.aliyun.com/api/emr/modifyuserstatistics.html
func (client *Client) ModifyUserStatistics(request *ModifyUserStatisticsRequest) (response *ModifyUserStatisticsResponse, err error) {
	response = CreateModifyUserStatisticsResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyUserStatisticsWithChan invokes the emr.ModifyUserStatistics API asynchronously
// api document: https://help.aliyun.com/api/emr/modifyuserstatistics.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyUserStatisticsWithChan(request *ModifyUserStatisticsRequest) (<-chan *ModifyUserStatisticsResponse, <-chan error) {
	responseChan := make(chan *ModifyUserStatisticsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyUserStatistics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyUserStatisticsWithCallback invokes the emr.ModifyUserStatistics API asynchronously
// api document: https://help.aliyun.com/api/emr/modifyuserstatistics.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyUserStatisticsWithCallback(request *ModifyUserStatisticsRequest, callback func(response *ModifyUserStatisticsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyUserStatisticsResponse
		var err error
		defer close(result)
		response, err = client.ModifyUserStatistics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyUserStatisticsRequest is the request struct for api ModifyUserStatistics
type ModifyUserStatisticsRequest struct {
	*requests.RpcRequest
	JobMigratedNum            requests.Integer `position:"Query" name:"JobMigratedNum"`
	ResourceOwnerId           requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ExecutePlanNum            requests.Integer `position:"Query" name:"ExecutePlanNum"`
	JobNum                    requests.Integer `position:"Query" name:"JobNum"`
	ExecutePlanMigratedNum    requests.Integer `position:"Query" name:"ExecutePlanMigratedNum"`
	InteractionJobMigratedNum requests.Integer `position:"Query" name:"InteractionJobMigratedNum"`
	UserId                    string           `position:"Query" name:"UserId"`
	InteractionJobNum         requests.Integer `position:"Query" name:"InteractionJobNum"`
}

// ModifyUserStatisticsResponse is the response struct for api ModifyUserStatistics
type ModifyUserStatisticsResponse struct {
	*responses.BaseResponse
}

// CreateModifyUserStatisticsRequest creates a request to invoke ModifyUserStatistics API
func CreateModifyUserStatisticsRequest() (request *ModifyUserStatisticsRequest) {
	request = &ModifyUserStatisticsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ModifyUserStatistics", "emr", "openAPI")
	return
}

// CreateModifyUserStatisticsResponse creates a response to parse from ModifyUserStatistics response
func CreateModifyUserStatisticsResponse() (response *ModifyUserStatisticsResponse) {
	response = &ModifyUserStatisticsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
