package ess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteScalingGroup invokes the ess.DeleteScalingGroup API synchronously
// api document: https://help.aliyun.com/api/ess/deletescalinggroup.html
func (client *Client) DeleteScalingGroup(request *DeleteScalingGroupRequest) (response *DeleteScalingGroupResponse, err error) {
	response = CreateDeleteScalingGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteScalingGroupWithChan invokes the ess.DeleteScalingGroup API asynchronously
// api document: https://help.aliyun.com/api/ess/deletescalinggroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteScalingGroupWithChan(request *DeleteScalingGroupRequest) (<-chan *DeleteScalingGroupResponse, <-chan error) {
	responseChan := make(chan *DeleteScalingGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteScalingGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteScalingGroupWithCallback invokes the ess.DeleteScalingGroup API asynchronously
// api document: https://help.aliyun.com/api/ess/deletescalinggroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteScalingGroupWithCallback(request *DeleteScalingGroupRequest, callback func(response *DeleteScalingGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteScalingGroupResponse
		var err error
		defer close(result)
		response, err = client.DeleteScalingGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteScalingGroupRequest is the request struct for api DeleteScalingGroup
type DeleteScalingGroupRequest struct {
	*requests.RpcRequest
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ScalingGroupId       string           `position:"Query" name:"ScalingGroupId"`
	ForceDelete          requests.Boolean `position:"Query" name:"ForceDelete"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteScalingGroupResponse is the response struct for api DeleteScalingGroup
type DeleteScalingGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteScalingGroupRequest creates a request to invoke DeleteScalingGroup API
func CreateDeleteScalingGroupRequest() (request *DeleteScalingGroupRequest) {
	request = &DeleteScalingGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ess", "2014-08-28", "DeleteScalingGroup", "ess", "openAPI")
	return
}

// CreateDeleteScalingGroupResponse creates a response to parse from DeleteScalingGroup response
func CreateDeleteScalingGroupResponse() (response *DeleteScalingGroupResponse) {
	response = &DeleteScalingGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
