package ess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RecordLifecycleActionHeartbeat invokes the ess.RecordLifecycleActionHeartbeat API synchronously
// api document: https://help.aliyun.com/api/ess/recordlifecycleactionheartbeat.html
func (client *Client) RecordLifecycleActionHeartbeat(request *RecordLifecycleActionHeartbeatRequest) (response *RecordLifecycleActionHeartbeatResponse, err error) {
	response = CreateRecordLifecycleActionHeartbeatResponse()
	err = client.DoAction(request, response)
	return
}

// RecordLifecycleActionHeartbeatWithChan invokes the ess.RecordLifecycleActionHeartbeat API asynchronously
// api document: https://help.aliyun.com/api/ess/recordlifecycleactionheartbeat.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RecordLifecycleActionHeartbeatWithChan(request *RecordLifecycleActionHeartbeatRequest) (<-chan *RecordLifecycleActionHeartbeatResponse, <-chan error) {
	responseChan := make(chan *RecordLifecycleActionHeartbeatResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RecordLifecycleActionHeartbeat(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RecordLifecycleActionHeartbeatWithCallback invokes the ess.RecordLifecycleActionHeartbeat API asynchronously
// api document: https://help.aliyun.com/api/ess/recordlifecycleactionheartbeat.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RecordLifecycleActionHeartbeatWithCallback(request *RecordLifecycleActionHeartbeatRequest, callback func(response *RecordLifecycleActionHeartbeatResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RecordLifecycleActionHeartbeatResponse
		var err error
		defer close(result)
		response, err = client.RecordLifecycleActionHeartbeat(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RecordLifecycleActionHeartbeatRequest is the request struct for api RecordLifecycleActionHeartbeat
type RecordLifecycleActionHeartbeatRequest struct {
	*requests.RpcRequest
	LifecycleActionToken string           `position:"Query" name:"lifecycleActionToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	HeartbeatTimeout     requests.Integer `position:"Query" name:"heartbeatTimeout"`
	LifecycleHookId      string           `position:"Query" name:"lifecycleHookId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// RecordLifecycleActionHeartbeatResponse is the response struct for api RecordLifecycleActionHeartbeat
type RecordLifecycleActionHeartbeatResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRecordLifecycleActionHeartbeatRequest creates a request to invoke RecordLifecycleActionHeartbeat API
func CreateRecordLifecycleActionHeartbeatRequest() (request *RecordLifecycleActionHeartbeatRequest) {
	request = &RecordLifecycleActionHeartbeatRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ess", "2014-08-28", "RecordLifecycleActionHeartbeat", "ess", "openAPI")
	return
}

// CreateRecordLifecycleActionHeartbeatResponse creates a response to parse from RecordLifecycleActionHeartbeat response
func CreateRecordLifecycleActionHeartbeatResponse() (response *RecordLifecycleActionHeartbeatResponse) {
	response = &RecordLifecycleActionHeartbeatResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
