package finmall

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CancelCredit invokes the finmall.CancelCredit API synchronously
// api document: https://help.aliyun.com/api/finmall/cancelcredit.html
func (client *Client) CancelCredit(request *CancelCreditRequest) (response *CancelCreditResponse, err error) {
	response = CreateCancelCreditResponse()
	err = client.DoAction(request, response)
	return
}

// CancelCreditWithChan invokes the finmall.CancelCredit API asynchronously
// api document: https://help.aliyun.com/api/finmall/cancelcredit.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CancelCreditWithChan(request *CancelCreditRequest) (<-chan *CancelCreditResponse, <-chan error) {
	responseChan := make(chan *CancelCreditResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CancelCredit(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CancelCreditWithCallback invokes the finmall.CancelCredit API asynchronously
// api document: https://help.aliyun.com/api/finmall/cancelcredit.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CancelCreditWithCallback(request *CancelCreditRequest, callback func(response *CancelCreditResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CancelCreditResponse
		var err error
		defer close(result)
		response, err = client.CancelCredit(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CancelCreditRequest is the request struct for api CancelCredit
type CancelCreditRequest struct {
	*requests.RpcRequest
	CreditId string `position:"Query" name:"CreditId"`
	UserId   string `position:"Query" name:"UserId"`
}

// CancelCreditResponse is the response struct for api CancelCredit
type CancelCreditResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCancelCreditRequest creates a request to invoke CancelCredit API
func CreateCancelCreditRequest() (request *CancelCreditRequest) {
	request = &CancelCreditRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("finmall", "2018-07-23", "CancelCredit", "finmall", "openAPI")
	return
}

// CreateCancelCreditResponse creates a response to parse from CancelCredit response
func CreateCancelCreditResponse() (response *CancelCreditResponse) {
	response = &CancelCreditResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
