package finmall

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PayForOrder invokes the finmall.PayForOrder API synchronously
// api document: https://help.aliyun.com/api/finmall/payfororder.html
func (client *Client) PayForOrder(request *PayForOrderRequest) (response *PayForOrderResponse, err error) {
	response = CreatePayForOrderResponse()
	err = client.DoAction(request, response)
	return
}

// PayForOrderWithChan invokes the finmall.PayForOrder API asynchronously
// api document: https://help.aliyun.com/api/finmall/payfororder.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PayForOrderWithChan(request *PayForOrderRequest) (<-chan *PayForOrderResponse, <-chan error) {
	responseChan := make(chan *PayForOrderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PayForOrder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PayForOrderWithCallback invokes the finmall.PayForOrder API asynchronously
// api document: https://help.aliyun.com/api/finmall/payfororder.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PayForOrderWithCallback(request *PayForOrderRequest, callback func(response *PayForOrderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PayForOrderResponse
		var err error
		defer close(result)
		response, err = client.PayForOrder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PayForOrderRequest is the request struct for api PayForOrder
type PayForOrderRequest struct {
	*requests.RpcRequest
	CreditId   string `position:"Query" name:"CreditId"`
	SmsIvToken string `position:"Query" name:"SmsIvToken"`
	UserId     string `position:"Query" name:"UserId"`
}

// PayForOrderResponse is the response struct for api PayForOrder
type PayForOrderResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreatePayForOrderRequest creates a request to invoke PayForOrder API
func CreatePayForOrderRequest() (request *PayForOrderRequest) {
	request = &PayForOrderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("finmall", "2018-07-23", "PayForOrder", "finmall", "openAPI")
	return
}

// CreatePayForOrderResponse creates a response to parse from PayForOrder response
func CreatePayForOrderResponse() (response *PayForOrderResponse) {
	response = &PayForOrderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
