package finmall

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateAuthenticationInfo invokes the finmall.UpdateAuthenticationInfo API synchronously
// api document: https://help.aliyun.com/api/finmall/updateauthenticationinfo.html
func (client *Client) UpdateAuthenticationInfo(request *UpdateAuthenticationInfoRequest) (response *UpdateAuthenticationInfoResponse, err error) {
	response = CreateUpdateAuthenticationInfoResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateAuthenticationInfoWithChan invokes the finmall.UpdateAuthenticationInfo API asynchronously
// api document: https://help.aliyun.com/api/finmall/updateauthenticationinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateAuthenticationInfoWithChan(request *UpdateAuthenticationInfoRequest) (<-chan *UpdateAuthenticationInfoResponse, <-chan error) {
	responseChan := make(chan *UpdateAuthenticationInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateAuthenticationInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateAuthenticationInfoWithCallback invokes the finmall.UpdateAuthenticationInfo API asynchronously
// api document: https://help.aliyun.com/api/finmall/updateauthenticationinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateAuthenticationInfoWithCallback(request *UpdateAuthenticationInfoRequest, callback func(response *UpdateAuthenticationInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateAuthenticationInfoResponse
		var err error
		defer close(result)
		response, err = client.UpdateAuthenticationInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateAuthenticationInfoRequest is the request struct for api UpdateAuthenticationInfo
type UpdateAuthenticationInfoRequest struct {
	*requests.RpcRequest
	IdCardNumber         string `position:"Body" name:"IdCardNumber"`
	Address              string `position:"Body" name:"Address"`
	EmployeeEmail        string `position:"Body" name:"EmployeeEmail"`
	EmployeePhoneNumber  string `position:"Body" name:"EmployeePhoneNumber"`
	PhoneNumber          string `position:"Body" name:"PhoneNumber"`
	BusinessLicense      string `position:"Body" name:"BusinessLicense"`
	LegalPersonName      string `position:"Body" name:"LegalPersonName"`
	UserId               string `position:"Body" name:"UserId"`
	SmsIvToken           string `position:"Body" name:"SmsIvToken"`
	BankCard             string `position:"Body" name:"BankCard"`
	Email                string `position:"Body" name:"Email"`
	EmployeeName         string `position:"Body" name:"EmployeeName"`
	EmployeeIdCardNumber string `position:"Body" name:"EmployeeIdCardNumber"`
}

// UpdateAuthenticationInfoResponse is the response struct for api UpdateAuthenticationInfo
type UpdateAuthenticationInfoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateUpdateAuthenticationInfoRequest creates a request to invoke UpdateAuthenticationInfo API
func CreateUpdateAuthenticationInfoRequest() (request *UpdateAuthenticationInfoRequest) {
	request = &UpdateAuthenticationInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("finmall", "2018-07-23", "UpdateAuthenticationInfo", "finmall", "openAPI")
	return
}

// CreateUpdateAuthenticationInfoResponse creates a response to parse from UpdateAuthenticationInfo response
func CreateUpdateAuthenticationInfoResponse() (response *UpdateAuthenticationInfoResponse) {
	response = &UpdateAuthenticationInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
