package imm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDocIndexTask invokes the imm.CreateDocIndexTask API synchronously
// api document: https://help.aliyun.com/api/imm/createdocindextask.html
func (client *Client) CreateDocIndexTask(request *CreateDocIndexTaskRequest) (response *CreateDocIndexTaskResponse, err error) {
	response = CreateCreateDocIndexTaskResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDocIndexTaskWithChan invokes the imm.CreateDocIndexTask API asynchronously
// api document: https://help.aliyun.com/api/imm/createdocindextask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateDocIndexTaskWithChan(request *CreateDocIndexTaskRequest) (<-chan *CreateDocIndexTaskResponse, <-chan error) {
	responseChan := make(chan *CreateDocIndexTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDocIndexTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDocIndexTaskWithCallback invokes the imm.CreateDocIndexTask API asynchronously
// api document: https://help.aliyun.com/api/imm/createdocindextask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateDocIndexTaskWithCallback(request *CreateDocIndexTaskRequest, callback func(response *CreateDocIndexTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDocIndexTaskResponse
		var err error
		defer close(result)
		response, err = client.CreateDocIndexTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDocIndexTaskRequest is the request struct for api CreateDocIndexTask
type CreateDocIndexTaskRequest struct {
	*requests.RpcRequest
	CustomKey1  string `position:"Query" name:"CustomKey1"`
	Set         string `position:"Query" name:"Set"`
	CustomKey5  string `position:"Query" name:"CustomKey5"`
	CustomKey4  string `position:"Query" name:"CustomKey4"`
	CustomKey3  string `position:"Query" name:"CustomKey3"`
	CustomKey2  string `position:"Query" name:"CustomKey2"`
	Project     string `position:"Query" name:"Project"`
	CustomKey6  string `position:"Query" name:"CustomKey6"`
	ContentType string `position:"Query" name:"ContentType"`
	Name        string `position:"Query" name:"Name"`
	SrcUri      string `position:"Query" name:"SrcUri"`
	UniqueId    string `position:"Query" name:"UniqueId"`
}

// CreateDocIndexTaskResponse is the response struct for api CreateDocIndexTask
type CreateDocIndexTaskResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	TaskId     string `json:"TaskId" xml:"TaskId"`
	Status     string `json:"Status" xml:"Status"`
	CreateTime string `json:"CreateTime" xml:"CreateTime"`
}

// CreateCreateDocIndexTaskRequest creates a request to invoke CreateDocIndexTask API
func CreateCreateDocIndexTaskRequest() (request *CreateDocIndexTaskRequest) {
	request = &CreateDocIndexTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imm", "2017-09-06", "CreateDocIndexTask", "imm", "openAPI")
	return
}

// CreateCreateDocIndexTaskResponse creates a response to parse from CreateDocIndexTask response
func CreateCreateDocIndexTaskResponse() (response *CreateDocIndexTaskResponse) {
	response = &CreateDocIndexTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
