package imm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPornBatchDetectJob invokes the imm.GetPornBatchDetectJob API synchronously
// api document: https://help.aliyun.com/api/imm/getpornbatchdetectjob.html
func (client *Client) GetPornBatchDetectJob(request *GetPornBatchDetectJobRequest) (response *GetPornBatchDetectJobResponse, err error) {
	response = CreateGetPornBatchDetectJobResponse()
	err = client.DoAction(request, response)
	return
}

// GetPornBatchDetectJobWithChan invokes the imm.GetPornBatchDetectJob API asynchronously
// api document: https://help.aliyun.com/api/imm/getpornbatchdetectjob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetPornBatchDetectJobWithChan(request *GetPornBatchDetectJobRequest) (<-chan *GetPornBatchDetectJobResponse, <-chan error) {
	responseChan := make(chan *GetPornBatchDetectJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPornBatchDetectJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPornBatchDetectJobWithCallback invokes the imm.GetPornBatchDetectJob API asynchronously
// api document: https://help.aliyun.com/api/imm/getpornbatchdetectjob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetPornBatchDetectJobWithCallback(request *GetPornBatchDetectJobRequest, callback func(response *GetPornBatchDetectJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPornBatchDetectJobResponse
		var err error
		defer close(result)
		response, err = client.GetPornBatchDetectJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPornBatchDetectJobRequest is the request struct for api GetPornBatchDetectJob
type GetPornBatchDetectJobRequest struct {
	*requests.RpcRequest
	JobId   string `position:"Query" name:"JobId"`
	Project string `position:"Query" name:"Project"`
}

// GetPornBatchDetectJobResponse is the response struct for api GetPornBatchDetectJob
type GetPornBatchDetectJobResponse struct {
	*responses.BaseResponse
	RequestId       string `json:"RequestId" xml:"RequestId"`
	JobId           string `json:"JobId" xml:"JobId"`
	SrcUri          string `json:"SrcUri" xml:"SrcUri"`
	TgtUri          string `json:"TgtUri" xml:"TgtUri"`
	NotifyTopicName string `json:"NotifyTopicName" xml:"NotifyTopicName"`
	NotifyEndpoint  string `json:"NotifyEndpoint" xml:"NotifyEndpoint"`
	ExternalID      string `json:"ExternalID" xml:"ExternalID"`
	Status          string `json:"Status" xml:"Status"`
	CreateTime      string `json:"CreateTime" xml:"CreateTime"`
	FinishTime      string `json:"FinishTime" xml:"FinishTime"`
	Percent         int    `json:"Percent" xml:"Percent"`
}

// CreateGetPornBatchDetectJobRequest creates a request to invoke GetPornBatchDetectJob API
func CreateGetPornBatchDetectJobRequest() (request *GetPornBatchDetectJobRequest) {
	request = &GetPornBatchDetectJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imm", "2017-09-06", "GetPornBatchDetectJob", "imm", "openAPI")
	return
}

// CreateGetPornBatchDetectJobResponse creates a response to parse from GetPornBatchDetectJob response
func CreateGetPornBatchDetectJobResponse() (response *GetPornBatchDetectJobResponse) {
	response = &GetPornBatchDetectJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
