package industry_brain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PostRealTimeDeviceData invokes the industry_brain.PostRealTimeDeviceData API synchronously
// api document: https://help.aliyun.com/api/industry-brain/postrealtimedevicedata.html
func (client *Client) PostRealTimeDeviceData(request *PostRealTimeDeviceDataRequest) (response *PostRealTimeDeviceDataResponse, err error) {
	response = CreatePostRealTimeDeviceDataResponse()
	err = client.DoAction(request, response)
	return
}

// PostRealTimeDeviceDataWithChan invokes the industry_brain.PostRealTimeDeviceData API asynchronously
// api document: https://help.aliyun.com/api/industry-brain/postrealtimedevicedata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PostRealTimeDeviceDataWithChan(request *PostRealTimeDeviceDataRequest) (<-chan *PostRealTimeDeviceDataResponse, <-chan error) {
	responseChan := make(chan *PostRealTimeDeviceDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PostRealTimeDeviceData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PostRealTimeDeviceDataWithCallback invokes the industry_brain.PostRealTimeDeviceData API asynchronously
// api document: https://help.aliyun.com/api/industry-brain/postrealtimedevicedata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PostRealTimeDeviceDataWithCallback(request *PostRealTimeDeviceDataRequest, callback func(response *PostRealTimeDeviceDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PostRealTimeDeviceDataResponse
		var err error
		defer close(result)
		response, err = client.PostRealTimeDeviceData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PostRealTimeDeviceDataRequest is the request struct for api PostRealTimeDeviceData
type PostRealTimeDeviceDataRequest struct {
	*requests.RpcRequest
	Data      string `position:"Body" name:"Data"`
	ServiceId string `position:"Body" name:"ServiceId"`
}

// PostRealTimeDeviceDataResponse is the response struct for api PostRealTimeDeviceData
type PostRealTimeDeviceDataResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreatePostRealTimeDeviceDataRequest creates a request to invoke PostRealTimeDeviceData API
func CreatePostRealTimeDeviceDataRequest() (request *PostRealTimeDeviceDataRequest) {
	request = &PostRealTimeDeviceDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("industry-brain", "2018-07-12", "PostRealTimeDeviceData", "", "")
	return
}

// CreatePostRealTimeDeviceDataResponse creates a response to parse from PostRealTimeDeviceData response
func CreatePostRealTimeDeviceDataResponse() (response *PostRealTimeDeviceDataResponse) {
	response = &PostRealTimeDeviceDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
