package ivision

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteTrainDatasTag invokes the ivision.DeleteTrainDatasTag API synchronously
// api document: https://help.aliyun.com/api/ivision/deletetraindatastag.html
func (client *Client) DeleteTrainDatasTag(request *DeleteTrainDatasTagRequest) (response *DeleteTrainDatasTagResponse, err error) {
	response = CreateDeleteTrainDatasTagResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteTrainDatasTagWithChan invokes the ivision.DeleteTrainDatasTag API asynchronously
// api document: https://help.aliyun.com/api/ivision/deletetraindatastag.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteTrainDatasTagWithChan(request *DeleteTrainDatasTagRequest) (<-chan *DeleteTrainDatasTagResponse, <-chan error) {
	responseChan := make(chan *DeleteTrainDatasTagResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteTrainDatasTag(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteTrainDatasTagWithCallback invokes the ivision.DeleteTrainDatasTag API asynchronously
// api document: https://help.aliyun.com/api/ivision/deletetraindatastag.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteTrainDatasTagWithCallback(request *DeleteTrainDatasTagRequest, callback func(response *DeleteTrainDatasTagResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteTrainDatasTagResponse
		var err error
		defer close(result)
		response, err = client.DeleteTrainDatasTag(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteTrainDatasTagRequest is the request struct for api DeleteTrainDatasTag
type DeleteTrainDatasTagRequest struct {
	*requests.RpcRequest
	DataIds   string           `position:"Query" name:"DataIds"`
	ProjectId string           `position:"Query" name:"ProjectId"`
	ShowLog   string           `position:"Query" name:"ShowLog"`
	TagId     string           `position:"Query" name:"TagId"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteTrainDatasTagResponse is the response struct for api DeleteTrainDatasTag
type DeleteTrainDatasTagResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteTrainDatasTagRequest creates a request to invoke DeleteTrainDatasTag API
func CreateDeleteTrainDatasTagRequest() (request *DeleteTrainDatasTagRequest) {
	request = &DeleteTrainDatasTagRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ivision", "2019-03-08", "DeleteTrainDatasTag", "ivision", "openAPI")
	return
}

// CreateDeleteTrainDatasTagResponse creates a response to parse from DeleteTrainDatasTag response
func CreateDeleteTrainDatasTagResponse() (response *DeleteTrainDatasTagResponse) {
	response = &DeleteTrainDatasTagResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
