package ivision

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeIterations invokes the ivision.DescribeIterations API synchronously
// api document: https://help.aliyun.com/api/ivision/describeiterations.html
func (client *Client) DescribeIterations(request *DescribeIterationsRequest) (response *DescribeIterationsResponse, err error) {
	response = CreateDescribeIterationsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeIterationsWithChan invokes the ivision.DescribeIterations API asynchronously
// api document: https://help.aliyun.com/api/ivision/describeiterations.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeIterationsWithChan(request *DescribeIterationsRequest) (<-chan *DescribeIterationsResponse, <-chan error) {
	responseChan := make(chan *DescribeIterationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeIterations(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeIterationsWithCallback invokes the ivision.DescribeIterations API asynchronously
// api document: https://help.aliyun.com/api/ivision/describeiterations.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeIterationsWithCallback(request *DescribeIterationsRequest, callback func(response *DescribeIterationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeIterationsResponse
		var err error
		defer close(result)
		response, err = client.DescribeIterations(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeIterationsRequest is the request struct for api DescribeIterations
type DescribeIterationsRequest struct {
	*requests.RpcRequest
	Threshold    string           `position:"Query" name:"Threshold"`
	ProjectId    string           `position:"Query" name:"ProjectId"`
	ShowLog      string           `position:"Query" name:"ShowLog"`
	IterationIds string           `position:"Query" name:"IterationIds"`
	OwnerId      requests.Integer `position:"Query" name:"OwnerId"`
	Status       string           `position:"Query" name:"Status"`
}

// DescribeIterationsResponse is the response struct for api DescribeIterations
type DescribeIterationsResponse struct {
	*responses.BaseResponse
	RequestId     string     `json:"RequestId" xml:"RequestId"`
	TotalNum      int        `json:"TotalNum" xml:"TotalNum"`
	CurrentPage   int        `json:"CurrentPage" xml:"CurrentPage"`
	PageSize      int        `json:"PageSize" xml:"PageSize"`
	NextPageToken string     `json:"NextPageToken" xml:"NextPageToken"`
	Iterations    Iterations `json:"Iterations" xml:"Iterations"`
}

// CreateDescribeIterationsRequest creates a request to invoke DescribeIterations API
func CreateDescribeIterationsRequest() (request *DescribeIterationsRequest) {
	request = &DescribeIterationsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ivision", "2019-03-08", "DescribeIterations", "ivision", "openAPI")
	return
}

// CreateDescribeIterationsResponse creates a response to parse from DescribeIterations response
func CreateDescribeIterationsResponse() (response *DescribeIterationsResponse) {
	response = &DescribeIterationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
