package ivision

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTrainResult invokes the ivision.DescribeTrainResult API synchronously
// api document: https://help.aliyun.com/api/ivision/describetrainresult.html
func (client *Client) DescribeTrainResult(request *DescribeTrainResultRequest) (response *DescribeTrainResultResponse, err error) {
	response = CreateDescribeTrainResultResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTrainResultWithChan invokes the ivision.DescribeTrainResult API asynchronously
// api document: https://help.aliyun.com/api/ivision/describetrainresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeTrainResultWithChan(request *DescribeTrainResultRequest) (<-chan *DescribeTrainResultResponse, <-chan error) {
	responseChan := make(chan *DescribeTrainResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTrainResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTrainResultWithCallback invokes the ivision.DescribeTrainResult API asynchronously
// api document: https://help.aliyun.com/api/ivision/describetrainresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeTrainResultWithCallback(request *DescribeTrainResultRequest, callback func(response *DescribeTrainResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTrainResultResponse
		var err error
		defer close(result)
		response, err = client.DescribeTrainResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTrainResultRequest is the request struct for api DescribeTrainResult
type DescribeTrainResultRequest struct {
	*requests.RpcRequest
	Threshold   string           `position:"Query" name:"Threshold"`
	ProjectId   string           `position:"Query" name:"ProjectId"`
	ShowLog     string           `position:"Query" name:"ShowLog"`
	OwnerId     requests.Integer `position:"Query" name:"OwnerId"`
	IterationId string           `position:"Query" name:"IterationId"`
}

// DescribeTrainResultResponse is the response struct for api DescribeTrainResult
type DescribeTrainResultResponse struct {
	*responses.BaseResponse
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	TrainResult TrainResult `json:"TrainResult" xml:"TrainResult"`
}

// CreateDescribeTrainResultRequest creates a request to invoke DescribeTrainResult API
func CreateDescribeTrainResultRequest() (request *DescribeTrainResultRequest) {
	request = &DescribeTrainResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ivision", "2019-03-08", "DescribeTrainResult", "ivision", "openAPI")
	return
}

// CreateDescribeTrainResultResponse creates a response to parse from DescribeTrainResult response
func CreateDescribeTrainResultResponse() (response *DescribeTrainResultResponse) {
	response = &DescribeTrainResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
