package ivision

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyProjectAttribute invokes the ivision.ModifyProjectAttribute API synchronously
// api document: https://help.aliyun.com/api/ivision/modifyprojectattribute.html
func (client *Client) ModifyProjectAttribute(request *ModifyProjectAttributeRequest) (response *ModifyProjectAttributeResponse, err error) {
	response = CreateModifyProjectAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyProjectAttributeWithChan invokes the ivision.ModifyProjectAttribute API asynchronously
// api document: https://help.aliyun.com/api/ivision/modifyprojectattribute.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyProjectAttributeWithChan(request *ModifyProjectAttributeRequest) (<-chan *ModifyProjectAttributeResponse, <-chan error) {
	responseChan := make(chan *ModifyProjectAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyProjectAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyProjectAttributeWithCallback invokes the ivision.ModifyProjectAttribute API asynchronously
// api document: https://help.aliyun.com/api/ivision/modifyprojectattribute.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyProjectAttributeWithCallback(request *ModifyProjectAttributeRequest, callback func(response *ModifyProjectAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyProjectAttributeResponse
		var err error
		defer close(result)
		response, err = client.ModifyProjectAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyProjectAttributeRequest is the request struct for api ModifyProjectAttribute
type ModifyProjectAttributeRequest struct {
	*requests.RpcRequest
	Description string           `position:"Query" name:"Description"`
	ProjectId   string           `position:"Query" name:"ProjectId"`
	ShowLog     string           `position:"Query" name:"ShowLog"`
	OwnerId     requests.Integer `position:"Query" name:"OwnerId"`
	Name        string           `position:"Query" name:"Name"`
}

// ModifyProjectAttributeResponse is the response struct for api ModifyProjectAttribute
type ModifyProjectAttributeResponse struct {
	*responses.BaseResponse
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Project   Project `json:"Project" xml:"Project"`
}

// CreateModifyProjectAttributeRequest creates a request to invoke ModifyProjectAttribute API
func CreateModifyProjectAttributeRequest() (request *ModifyProjectAttributeRequest) {
	request = &ModifyProjectAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ivision", "2019-03-08", "ModifyProjectAttribute", "ivision", "openAPI")
	return
}

// CreateModifyProjectAttributeResponse creates a response to parse from ModifyProjectAttribute response
func CreateModifyProjectAttributeResponse() (response *ModifyProjectAttributeResponse) {
	response = &ModifyProjectAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
