package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ApplyBoardToken invokes the live.ApplyBoardToken API synchronously
// api document: https://help.aliyun.com/api/live/applyboardtoken.html
func (client *Client) ApplyBoardToken(request *ApplyBoardTokenRequest) (response *ApplyBoardTokenResponse, err error) {
	response = CreateApplyBoardTokenResponse()
	err = client.DoAction(request, response)
	return
}

// ApplyBoardTokenWithChan invokes the live.ApplyBoardToken API asynchronously
// api document: https://help.aliyun.com/api/live/applyboardtoken.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ApplyBoardTokenWithChan(request *ApplyBoardTokenRequest) (<-chan *ApplyBoardTokenResponse, <-chan error) {
	responseChan := make(chan *ApplyBoardTokenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ApplyBoardToken(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ApplyBoardTokenWithCallback invokes the live.ApplyBoardToken API asynchronously
// api document: https://help.aliyun.com/api/live/applyboardtoken.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ApplyBoardTokenWithCallback(request *ApplyBoardTokenRequest, callback func(response *ApplyBoardTokenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ApplyBoardTokenResponse
		var err error
		defer close(result)
		response, err = client.ApplyBoardToken(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ApplyBoardTokenRequest is the request struct for api ApplyBoardToken
type ApplyBoardTokenRequest struct {
	*requests.RpcRequest
	BoardId string           `position:"Query" name:"BoardId"`
	AppUid  string           `position:"Query" name:"AppUid"`
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
	AppId   string           `position:"Query" name:"AppId"`
}

// ApplyBoardTokenResponse is the response struct for api ApplyBoardToken
type ApplyBoardTokenResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Token     string `json:"Token" xml:"Token"`
	Expired   string `json:"Expired" xml:"Expired"`
}

// CreateApplyBoardTokenRequest creates a request to invoke ApplyBoardToken API
func CreateApplyBoardTokenRequest() (request *ApplyBoardTokenRequest) {
	request = &ApplyBoardTokenRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "ApplyBoardToken", "live", "openAPI")
	return
}

// CreateApplyBoardTokenResponse creates a response to parse from ApplyBoardToken response
func CreateApplyBoardTokenResponse() (response *ApplyBoardTokenResponse) {
	response = &ApplyBoardTokenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
