package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetCasterSceneConfig invokes the live.SetCasterSceneConfig API synchronously
// api document: https://help.aliyun.com/api/live/setcastersceneconfig.html
func (client *Client) SetCasterSceneConfig(request *SetCasterSceneConfigRequest) (response *SetCasterSceneConfigResponse, err error) {
	response = CreateSetCasterSceneConfigResponse()
	err = client.DoAction(request, response)
	return
}

// SetCasterSceneConfigWithChan invokes the live.SetCasterSceneConfig API asynchronously
// api document: https://help.aliyun.com/api/live/setcastersceneconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetCasterSceneConfigWithChan(request *SetCasterSceneConfigRequest) (<-chan *SetCasterSceneConfigResponse, <-chan error) {
	responseChan := make(chan *SetCasterSceneConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetCasterSceneConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetCasterSceneConfigWithCallback invokes the live.SetCasterSceneConfig API asynchronously
// api document: https://help.aliyun.com/api/live/setcastersceneconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetCasterSceneConfigWithCallback(request *SetCasterSceneConfigRequest, callback func(response *SetCasterSceneConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetCasterSceneConfigResponse
		var err error
		defer close(result)
		response, err = client.SetCasterSceneConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetCasterSceneConfigRequest is the request struct for api SetCasterSceneConfig
type SetCasterSceneConfigRequest struct {
	*requests.RpcRequest
	ComponentId *[]string        `position:"Query" name:"ComponentId"  type:"Repeated"`
	CasterId    string           `position:"Query" name:"CasterId"`
	SceneId     string           `position:"Query" name:"SceneId"`
	OwnerId     requests.Integer `position:"Query" name:"OwnerId"`
	LayoutId    string           `position:"Query" name:"LayoutId"`
}

// SetCasterSceneConfigResponse is the response struct for api SetCasterSceneConfig
type SetCasterSceneConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetCasterSceneConfigRequest creates a request to invoke SetCasterSceneConfig API
func CreateSetCasterSceneConfigRequest() (request *SetCasterSceneConfigRequest) {
	request = &SetCasterSceneConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "SetCasterSceneConfig", "live", "openAPI")
	return
}

// CreateSetCasterSceneConfigResponse creates a response to parse from SetCasterSceneConfig response
func CreateSetCasterSceneConfigResponse() (response *SetCasterSceneConfigResponse) {
	response = &SetCasterSceneConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
