package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PhysicalDeleteResource invokes the mts.PhysicalDeleteResource API synchronously
// api document: https://help.aliyun.com/api/mts/physicaldeleteresource.html
func (client *Client) PhysicalDeleteResource(request *PhysicalDeleteResourceRequest) (response *PhysicalDeleteResourceResponse, err error) {
	response = CreatePhysicalDeleteResourceResponse()
	err = client.DoAction(request, response)
	return
}

// PhysicalDeleteResourceWithChan invokes the mts.PhysicalDeleteResource API asynchronously
// api document: https://help.aliyun.com/api/mts/physicaldeleteresource.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PhysicalDeleteResourceWithChan(request *PhysicalDeleteResourceRequest) (<-chan *PhysicalDeleteResourceResponse, <-chan error) {
	responseChan := make(chan *PhysicalDeleteResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PhysicalDeleteResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PhysicalDeleteResourceWithCallback invokes the mts.PhysicalDeleteResource API asynchronously
// api document: https://help.aliyun.com/api/mts/physicaldeleteresource.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PhysicalDeleteResourceWithCallback(request *PhysicalDeleteResourceRequest, callback func(response *PhysicalDeleteResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PhysicalDeleteResourceResponse
		var err error
		defer close(result)
		response, err = client.PhysicalDeleteResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PhysicalDeleteResourceRequest is the request struct for api PhysicalDeleteResource
type PhysicalDeleteResourceRequest struct {
	*requests.RpcRequest
	Country        string           `position:"Query" name:"Country"`
	Hid            requests.Integer `position:"Query" name:"Hid"`
	Success        requests.Boolean `position:"Query" name:"Success"`
	Interrupt      requests.Boolean `position:"Query" name:"Interrupt"`
	GmtWakeup      string           `position:"Query" name:"GmtWakeup"`
	Pk             string           `position:"Query" name:"Pk"`
	Invoker        string           `position:"Query" name:"Invoker"`
	Bid            string           `position:"Query" name:"Bid"`
	Message        string           `position:"Query" name:"Message"`
	TaskExtraData  string           `position:"Query" name:"TaskExtraData"`
	TaskIdentifier string           `position:"Query" name:"TaskIdentifier"`
}

// PhysicalDeleteResourceResponse is the response struct for api PhysicalDeleteResource
type PhysicalDeleteResourceResponse struct {
	*responses.BaseResponse
	Interrupt      bool   `json:"Interrupt" xml:"Interrupt"`
	Invoker        string `json:"Invoker" xml:"Invoker"`
	Pk             string `json:"Pk" xml:"Pk"`
	Bid            string `json:"Bid" xml:"Bid"`
	Hid            int    `json:"Hid" xml:"Hid"`
	Country        string `json:"Country" xml:"Country"`
	TaskIdentifier string `json:"TaskIdentifier" xml:"TaskIdentifier"`
	TaskExtraData  string `json:"TaskExtraData" xml:"TaskExtraData"`
	GmtWakeup      string `json:"GmtWakeup" xml:"GmtWakeup"`
	Success        bool   `json:"Success" xml:"Success"`
	Message        string `json:"Message" xml:"Message"`
}

// CreatePhysicalDeleteResourceRequest creates a request to invoke PhysicalDeleteResource API
func CreatePhysicalDeleteResourceRequest() (request *PhysicalDeleteResourceRequest) {
	request = &PhysicalDeleteResourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "PhysicalDeleteResource", "mts", "openAPI")
	return
}

// CreatePhysicalDeleteResourceResponse creates a response to parse from PhysicalDeleteResource response
func CreatePhysicalDeleteResourceResponse() (response *PhysicalDeleteResourceResponse) {
	response = &PhysicalDeleteResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
