//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package nas

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteTieringPolicy invokes the nas.DeleteTieringPolicy API synchronously
// api document: https://help.aliyun.com/api/nas/deletetieringpolicy.html
func (client *Client) DeleteTieringPolicy(request *DeleteTieringPolicyRequest) (response *DeleteTieringPolicyResponse, err error) {
	response = CreateDeleteTieringPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteTieringPolicyWithChan invokes the nas.DeleteTieringPolicy API asynchronously
// api document: https://help.aliyun.com/api/nas/deletetieringpolicy.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteTieringPolicyWithChan(request *DeleteTieringPolicyRequest) (<-chan *DeleteTieringPolicyResponse, <-chan error) {
	responseChan := make(chan *DeleteTieringPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteTieringPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteTieringPolicyWithCallback invokes the nas.DeleteTieringPolicy API asynchronously
// api document: https://help.aliyun.com/api/nas/deletetieringpolicy.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteTieringPolicyWithCallback(request *DeleteTieringPolicyRequest, callback func(response *DeleteTieringPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteTieringPolicyResponse
		var err error
		defer close(result)
		response, err = client.DeleteTieringPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteTieringPolicyRequest is the request struct for api DeleteTieringPolicy
type DeleteTieringPolicyRequest struct {
	*requests.RpcRequest
	Name string `position:"Query" name:"Name"`
}

// DeleteTieringPolicyResponse is the response struct for api DeleteTieringPolicy
type DeleteTieringPolicyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateDeleteTieringPolicyRequest creates a request to invoke DeleteTieringPolicy API
func CreateDeleteTieringPolicyRequest() (request *DeleteTieringPolicyRequest) {
	request = &DeleteTieringPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("NAS", "2017-06-26", "DeleteTieringPolicy", "nas", "openAPI")
	return
}

// CreateDeleteTieringPolicyResponse creates a response to parse from DeleteTieringPolicy response
func CreateDeleteTieringPolicyResponse() (response *DeleteTieringPolicyResponse) {
	response = &DeleteTieringPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
