package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListTagResources invokes the r_kvstore.ListTagResources API synchronously
// api document: https://help.aliyun.com/api/r-kvstore/listtagresources.html
func (client *Client) ListTagResources(request *ListTagResourcesRequest) (response *ListTagResourcesResponse, err error) {
	response = CreateListTagResourcesResponse()
	err = client.DoAction(request, response)
	return
}

// ListTagResourcesWithChan invokes the r_kvstore.ListTagResources API asynchronously
// api document: https://help.aliyun.com/api/r-kvstore/listtagresources.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListTagResourcesWithChan(request *ListTagResourcesRequest) (<-chan *ListTagResourcesResponse, <-chan error) {
	responseChan := make(chan *ListTagResourcesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTagResources(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListTagResourcesWithCallback invokes the r_kvstore.ListTagResources API asynchronously
// api document: https://help.aliyun.com/api/r-kvstore/listtagresources.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListTagResourcesWithCallback(request *ListTagResourcesRequest, callback func(response *ListTagResourcesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTagResourcesResponse
		var err error
		defer close(result)
		response, err = client.ListTagResources(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListTagResourcesRequest is the request struct for api ListTagResources
type ListTagResourcesRequest struct {
	*requests.RpcRequest
	ResourceId47         string           `position:"Query" name:"ResourceId.47"`
	ResourceId48         string           `position:"Query" name:"ResourceId.48"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceId49         string           `position:"Query" name:"ResourceId.49"`
	ResourceId40         string           `position:"Query" name:"ResourceId.40"`
	ResourceId41         string           `position:"Query" name:"ResourceId.41"`
	ResourceId42         string           `position:"Query" name:"ResourceId.42"`
	TagKey9              string           `position:"Query" name:"TagKey.9"`
	ResourceId1          string           `position:"Query" name:"ResourceId.1"`
	ResourceId43         string           `position:"Query" name:"ResourceId.43"`
	ResourceId2          string           `position:"Query" name:"ResourceId.2"`
	ResourceId44         string           `position:"Query" name:"ResourceId.44"`
	ResourceId3          string           `position:"Query" name:"ResourceId.3"`
	ResourceId45         string           `position:"Query" name:"ResourceId.45"`
	ResourceId4          string           `position:"Query" name:"ResourceId.4"`
	ResourceId46         string           `position:"Query" name:"ResourceId.46"`
	ResourceId5          string           `position:"Query" name:"ResourceId.5"`
	TagKey4              string           `position:"Query" name:"TagKey.4"`
	ResourceId6          string           `position:"Query" name:"ResourceId.6"`
	TagKey3              string           `position:"Query" name:"TagKey.3"`
	ResourceId7          string           `position:"Query" name:"ResourceId.7"`
	TagKey2              string           `position:"Query" name:"TagKey.2"`
	ResourceId8          string           `position:"Query" name:"ResourceId.8"`
	TagKey1              string           `position:"Query" name:"TagKey.1"`
	ResourceId9          string           `position:"Query" name:"ResourceId.9"`
	TagKey8              string           `position:"Query" name:"TagKey.8"`
	TagKey20             string           `position:"Query" name:"TagKey.20"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	TagKey7              string           `position:"Query" name:"TagKey.7"`
	TagKey6              string           `position:"Query" name:"TagKey.6"`
	TagKey5              string           `position:"Query" name:"TagKey.5"`
	ResourceId36         string           `position:"Query" name:"ResourceId.36"`
	ResourceId37         string           `position:"Query" name:"ResourceId.37"`
	ResourceId38         string           `position:"Query" name:"ResourceId.38"`
	ResourceId39         string           `position:"Query" name:"ResourceId.39"`
	ResourceId30         string           `position:"Query" name:"ResourceId.30"`
	ResourceId31         string           `position:"Query" name:"ResourceId.31"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ResourceId32         string           `position:"Query" name:"ResourceId.32"`
	ResourceId33         string           `position:"Query" name:"ResourceId.33"`
	ResourceId34         string           `position:"Query" name:"ResourceId.34"`
	ResourceId35         string           `position:"Query" name:"ResourceId.35"`
	ResourceId25         string           `position:"Query" name:"ResourceId.25"`
	ResourceId26         string           `position:"Query" name:"ResourceId.26"`
	ResourceId27         string           `position:"Query" name:"ResourceId.27"`
	ResourceId28         string           `position:"Query" name:"ResourceId.28"`
	ResourceId29         string           `position:"Query" name:"ResourceId.29"`
	ResourceId20         string           `position:"Query" name:"ResourceId.20"`
	ResourceId21         string           `position:"Query" name:"ResourceId.21"`
	ResourceId22         string           `position:"Query" name:"ResourceId.22"`
	ResourceId23         string           `position:"Query" name:"ResourceId.23"`
	ResourceId24         string           `position:"Query" name:"ResourceId.24"`
	NextToken            string           `position:"Query" name:"NextToken"`
	Scope                string           `position:"Query" name:"Scope"`
	ResourceId14         string           `position:"Query" name:"ResourceId.14"`
	ResourceId15         string           `position:"Query" name:"ResourceId.15"`
	ResourceId16         string           `position:"Query" name:"ResourceId.16"`
	TagKey19             string           `position:"Query" name:"TagKey.19"`
	ResourceId17         string           `position:"Query" name:"ResourceId.17"`
	TagKey18             string           `position:"Query" name:"TagKey.18"`
	ResourceId18         string           `position:"Query" name:"ResourceId.18"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ResourceId19         string           `position:"Query" name:"ResourceId.19"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	ResourceId50         string           `position:"Query" name:"ResourceId.50"`
	ResourceId10         string           `position:"Query" name:"ResourceId.10"`
	ResourceType         string           `position:"Query" name:"ResourceType"`
	ResourceId11         string           `position:"Query" name:"ResourceId.11"`
	ResourceId12         string           `position:"Query" name:"ResourceId.12"`
	ResourceId13         string           `position:"Query" name:"ResourceId.13"`
	TagKey13             string           `position:"Query" name:"TagKey.13"`
	TagKey12             string           `position:"Query" name:"TagKey.12"`
	TagKey11             string           `position:"Query" name:"TagKey.11"`
	TagKey10             string           `position:"Query" name:"TagKey.10"`
	TagKey17             string           `position:"Query" name:"TagKey.17"`
	TagKey16             string           `position:"Query" name:"TagKey.16"`
	TagKey15             string           `position:"Query" name:"TagKey.15"`
	TagKey14             string           `position:"Query" name:"TagKey.14"`
}

// ListTagResourcesResponse is the response struct for api ListTagResources
type ListTagResourcesResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	TagResources TagResources `json:"TagResources" xml:"TagResources"`
}

// CreateListTagResourcesRequest creates a request to invoke ListTagResources API
func CreateListTagResourcesRequest() (request *ListTagResourcesRequest) {
	request = &ListTagResourcesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "ListTagResources", "redisa", "openAPI")
	return
}

// CreateListTagResourcesResponse creates a response to parse from ListTagResources response
func CreateListTagResourcesResponse() (response *ListTagResourcesResponse) {
	response = &ListTagResourcesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
