package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTaskInfo invokes the rds.DescribeTaskInfo API synchronously
// api document: https://help.aliyun.com/api/rds/describetaskinfo.html
func (client *Client) DescribeTaskInfo(request *DescribeTaskInfoRequest) (response *DescribeTaskInfoResponse, err error) {
	response = CreateDescribeTaskInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTaskInfoWithChan invokes the rds.DescribeTaskInfo API asynchronously
// api document: https://help.aliyun.com/api/rds/describetaskinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeTaskInfoWithChan(request *DescribeTaskInfoRequest) (<-chan *DescribeTaskInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeTaskInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTaskInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTaskInfoWithCallback invokes the rds.DescribeTaskInfo API asynchronously
// api document: https://help.aliyun.com/api/rds/describetaskinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeTaskInfoWithCallback(request *DescribeTaskInfoRequest, callback func(response *DescribeTaskInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTaskInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeTaskInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTaskInfoRequest is the request struct for api DescribeTaskInfo
type DescribeTaskInfoRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	TaskId               requests.Integer `position:"Query" name:"TaskId"`
}

// DescribeTaskInfoResponse is the response struct for api DescribeTaskInfo
type DescribeTaskInfoResponse struct {
	*responses.BaseResponse
	RequestId          string `json:"RequestId" xml:"RequestId"`
	TaskId             string `json:"TaskId" xml:"TaskId"`
	BeginTime          string `json:"BeginTime" xml:"BeginTime"`
	FinishTime         string `json:"FinishTime" xml:"FinishTime"`
	CreateTime         string `json:"CreateTime" xml:"CreateTime"`
	TaskAction         string `json:"TaskAction" xml:"TaskAction"`
	DBName             string `json:"DBName" xml:"DBName"`
	TaskErrorCode      string `json:"TaskErrorCode" xml:"TaskErrorCode"`
	Progress           string `json:"Progress" xml:"Progress"`
	ExpectedFinishTime string `json:"ExpectedFinishTime" xml:"ExpectedFinishTime"`
	TaskErrorMessage   string `json:"TaskErrorMessage" xml:"TaskErrorMessage"`
	ProgressInfo       string `json:"ProgressInfo" xml:"ProgressInfo"`
	Status             string `json:"Status" xml:"Status"`
}

// CreateDescribeTaskInfoRequest creates a request to invoke DescribeTaskInfo API
func CreateDescribeTaskInfoRequest() (request *DescribeTaskInfoRequest) {
	request = &DescribeTaskInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "DescribeTaskInfo", "rds", "openAPI")
	return
}

// CreateDescribeTaskInfoResponse creates a response to parse from DescribeTaskInfo response
func CreateDescribeTaskInfoResponse() (response *DescribeTaskInfoResponse) {
	response = &DescribeTaskInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
