package scdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeScdnDomainRealTimeBpsData invokes the scdn.DescribeScdnDomainRealTimeBpsData API synchronously
// api document: https://help.aliyun.com/api/scdn/describescdndomainrealtimebpsdata.html
func (client *Client) DescribeScdnDomainRealTimeBpsData(request *DescribeScdnDomainRealTimeBpsDataRequest) (response *DescribeScdnDomainRealTimeBpsDataResponse, err error) {
	response = CreateDescribeScdnDomainRealTimeBpsDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeScdnDomainRealTimeBpsDataWithChan invokes the scdn.DescribeScdnDomainRealTimeBpsData API asynchronously
// api document: https://help.aliyun.com/api/scdn/describescdndomainrealtimebpsdata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeScdnDomainRealTimeBpsDataWithChan(request *DescribeScdnDomainRealTimeBpsDataRequest) (<-chan *DescribeScdnDomainRealTimeBpsDataResponse, <-chan error) {
	responseChan := make(chan *DescribeScdnDomainRealTimeBpsDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeScdnDomainRealTimeBpsData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeScdnDomainRealTimeBpsDataWithCallback invokes the scdn.DescribeScdnDomainRealTimeBpsData API asynchronously
// api document: https://help.aliyun.com/api/scdn/describescdndomainrealtimebpsdata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeScdnDomainRealTimeBpsDataWithCallback(request *DescribeScdnDomainRealTimeBpsDataRequest, callback func(response *DescribeScdnDomainRealTimeBpsDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeScdnDomainRealTimeBpsDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeScdnDomainRealTimeBpsData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeScdnDomainRealTimeBpsDataRequest is the request struct for api DescribeScdnDomainRealTimeBpsData
type DescribeScdnDomainRealTimeBpsDataRequest struct {
	*requests.RpcRequest
	LocationNameEn string           `position:"Query" name:"LocationNameEn"`
	IspNameEn      string           `position:"Query" name:"IspNameEn"`
	StartTime      string           `position:"Query" name:"StartTime"`
	DomainName     string           `position:"Query" name:"DomainName"`
	EndTime        string           `position:"Query" name:"EndTime"`
	OwnerId        requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeScdnDomainRealTimeBpsDataResponse is the response struct for api DescribeScdnDomainRealTimeBpsData
type DescribeScdnDomainRealTimeBpsDataResponse struct {
	*responses.BaseResponse
	RequestId string                                  `json:"RequestId" xml:"RequestId"`
	Data      DataInDescribeScdnDomainRealTimeBpsData `json:"Data" xml:"Data"`
}

// CreateDescribeScdnDomainRealTimeBpsDataRequest creates a request to invoke DescribeScdnDomainRealTimeBpsData API
func CreateDescribeScdnDomainRealTimeBpsDataRequest() (request *DescribeScdnDomainRealTimeBpsDataRequest) {
	request = &DescribeScdnDomainRealTimeBpsDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scdn", "2017-11-15", "DescribeScdnDomainRealTimeBpsData", "scdn", "openAPI")
	return
}

// CreateDescribeScdnDomainRealTimeBpsDataResponse creates a response to parse from DescribeScdnDomainRealTimeBpsData response
func CreateDescribeScdnDomainRealTimeBpsDataResponse() (response *DescribeScdnDomainRealTimeBpsDataResponse) {
	response = &DescribeScdnDomainRealTimeBpsDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
