package slb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetAutoRenewStatus invokes the slb.SetAutoRenewStatus API synchronously
// api document: https://help.aliyun.com/api/slb/setautorenewstatus.html
func (client *Client) SetAutoRenewStatus(request *SetAutoRenewStatusRequest) (response *SetAutoRenewStatusResponse, err error) {
	response = CreateSetAutoRenewStatusResponse()
	err = client.DoAction(request, response)
	return
}

// SetAutoRenewStatusWithChan invokes the slb.SetAutoRenewStatus API asynchronously
// api document: https://help.aliyun.com/api/slb/setautorenewstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetAutoRenewStatusWithChan(request *SetAutoRenewStatusRequest) (<-chan *SetAutoRenewStatusResponse, <-chan error) {
	responseChan := make(chan *SetAutoRenewStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetAutoRenewStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetAutoRenewStatusWithCallback invokes the slb.SetAutoRenewStatus API asynchronously
// api document: https://help.aliyun.com/api/slb/setautorenewstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetAutoRenewStatusWithCallback(request *SetAutoRenewStatusRequest, callback func(response *SetAutoRenewStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetAutoRenewStatusResponse
		var err error
		defer close(result)
		response, err = client.SetAutoRenewStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetAutoRenewStatusRequest is the request struct for api SetAutoRenewStatus
type SetAutoRenewStatusRequest struct {
	*requests.RpcRequest
	AccessKeyId          string           `position:"Query" name:"access_key_id"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	RenewalDuration      requests.Integer `position:"Query" name:"RenewalDuration"`
	LoadBalancerId       string           `position:"Query" name:"LoadBalancerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	RenewalStatus        string           `position:"Query" name:"RenewalStatus"`
	RenewalCycUnit       string           `position:"Query" name:"RenewalCycUnit"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Tags                 string           `position:"Query" name:"Tags"`
}

// SetAutoRenewStatusResponse is the response struct for api SetAutoRenewStatus
type SetAutoRenewStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetAutoRenewStatusRequest creates a request to invoke SetAutoRenewStatus API
func CreateSetAutoRenewStatusRequest() (request *SetAutoRenewStatusRequest) {
	request = &SetAutoRenewStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Slb", "2014-05-15", "SetAutoRenewStatus", "slb", "openAPI")
	return
}

// CreateSetAutoRenewStatusResponse creates a response to parse from SetAutoRenewStatus response
func CreateSetAutoRenewStatusResponse() (response *SetAutoRenewStatusResponse) {
	response = &SetAutoRenewStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
