package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SwitchSAGHaState invokes the smartag.SwitchSAGHaState API synchronously
// api document: https://help.aliyun.com/api/smartag/switchsaghastate.html
func (client *Client) SwitchSAGHaState(request *SwitchSAGHaStateRequest) (response *SwitchSAGHaStateResponse, err error) {
	response = CreateSwitchSAGHaStateResponse()
	err = client.DoAction(request, response)
	return
}

// SwitchSAGHaStateWithChan invokes the smartag.SwitchSAGHaState API asynchronously
// api document: https://help.aliyun.com/api/smartag/switchsaghastate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SwitchSAGHaStateWithChan(request *SwitchSAGHaStateRequest) (<-chan *SwitchSAGHaStateResponse, <-chan error) {
	responseChan := make(chan *SwitchSAGHaStateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SwitchSAGHaState(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SwitchSAGHaStateWithCallback invokes the smartag.SwitchSAGHaState API asynchronously
// api document: https://help.aliyun.com/api/smartag/switchsaghastate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SwitchSAGHaStateWithCallback(request *SwitchSAGHaStateRequest, callback func(response *SwitchSAGHaStateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SwitchSAGHaStateResponse
		var err error
		defer close(result)
		response, err = client.SwitchSAGHaState(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SwitchSAGHaStateRequest is the request struct for api SwitchSAGHaState
type SwitchSAGHaStateRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	HaType               string           `position:"Query" name:"HaType"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// SwitchSAGHaStateResponse is the response struct for api SwitchSAGHaState
type SwitchSAGHaStateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSwitchSAGHaStateRequest creates a request to invoke SwitchSAGHaState API
func CreateSwitchSAGHaStateRequest() (request *SwitchSAGHaStateRequest) {
	request = &SwitchSAGHaStateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "SwitchSAGHaState", "smartag", "openAPI")
	return
}

// CreateSwitchSAGHaStateResponse creates a response to parse from SwitchSAGHaState response
func CreateSwitchSAGHaStateResponse() (response *SwitchSAGHaStateResponse) {
	response = &SwitchSAGHaStateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
