package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetDefaultWatermark invokes the vod.SetDefaultWatermark API synchronously
// api document: https://help.aliyun.com/api/vod/setdefaultwatermark.html
func (client *Client) SetDefaultWatermark(request *SetDefaultWatermarkRequest) (response *SetDefaultWatermarkResponse, err error) {
	response = CreateSetDefaultWatermarkResponse()
	err = client.DoAction(request, response)
	return
}

// SetDefaultWatermarkWithChan invokes the vod.SetDefaultWatermark API asynchronously
// api document: https://help.aliyun.com/api/vod/setdefaultwatermark.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetDefaultWatermarkWithChan(request *SetDefaultWatermarkRequest) (<-chan *SetDefaultWatermarkResponse, <-chan error) {
	responseChan := make(chan *SetDefaultWatermarkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetDefaultWatermark(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetDefaultWatermarkWithCallback invokes the vod.SetDefaultWatermark API asynchronously
// api document: https://help.aliyun.com/api/vod/setdefaultwatermark.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetDefaultWatermarkWithCallback(request *SetDefaultWatermarkRequest, callback func(response *SetDefaultWatermarkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetDefaultWatermarkResponse
		var err error
		defer close(result)
		response, err = client.SetDefaultWatermark(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetDefaultWatermarkRequest is the request struct for api SetDefaultWatermark
type SetDefaultWatermarkRequest struct {
	*requests.RpcRequest
	WatermarkId          string           `position:"Query" name:"WatermarkId"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// SetDefaultWatermarkResponse is the response struct for api SetDefaultWatermark
type SetDefaultWatermarkResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetDefaultWatermarkRequest creates a request to invoke SetDefaultWatermark API
func CreateSetDefaultWatermarkRequest() (request *SetDefaultWatermarkRequest) {
	request = &SetDefaultWatermarkRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "SetDefaultWatermark", "vod", "openAPI")
	return
}

// CreateSetDefaultWatermarkResponse creates a response to parse from SetDefaultWatermark response
func CreateSetDefaultWatermarkResponse() (response *SetDefaultWatermarkResponse) {
	response = &SetDefaultWatermarkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
