package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateTranscodeTemplateGroup invokes the vod.UpdateTranscodeTemplateGroup API synchronously
// api document: https://help.aliyun.com/api/vod/updatetranscodetemplategroup.html
func (client *Client) UpdateTranscodeTemplateGroup(request *UpdateTranscodeTemplateGroupRequest) (response *UpdateTranscodeTemplateGroupResponse, err error) {
	response = CreateUpdateTranscodeTemplateGroupResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateTranscodeTemplateGroupWithChan invokes the vod.UpdateTranscodeTemplateGroup API asynchronously
// api document: https://help.aliyun.com/api/vod/updatetranscodetemplategroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateTranscodeTemplateGroupWithChan(request *UpdateTranscodeTemplateGroupRequest) (<-chan *UpdateTranscodeTemplateGroupResponse, <-chan error) {
	responseChan := make(chan *UpdateTranscodeTemplateGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateTranscodeTemplateGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateTranscodeTemplateGroupWithCallback invokes the vod.UpdateTranscodeTemplateGroup API asynchronously
// api document: https://help.aliyun.com/api/vod/updatetranscodetemplategroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateTranscodeTemplateGroupWithCallback(request *UpdateTranscodeTemplateGroupRequest, callback func(response *UpdateTranscodeTemplateGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateTranscodeTemplateGroupResponse
		var err error
		defer close(result)
		response, err = client.UpdateTranscodeTemplateGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateTranscodeTemplateGroupRequest is the request struct for api UpdateTranscodeTemplateGroup
type UpdateTranscodeTemplateGroupRequest struct {
	*requests.RpcRequest
	TranscodeTemplateList    string           `position:"Query" name:"TranscodeTemplateList"`
	ResourceOwnerId          requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount     string           `position:"Query" name:"ResourceOwnerAccount"`
	Name                     string           `position:"Query" name:"Name"`
	OwnerId                  requests.Integer `position:"Query" name:"OwnerId"`
	Locked                   string           `position:"Query" name:"Locked"`
	TranscodeTemplateGroupId string           `position:"Query" name:"TranscodeTemplateGroupId"`
}

// UpdateTranscodeTemplateGroupResponse is the response struct for api UpdateTranscodeTemplateGroup
type UpdateTranscodeTemplateGroupResponse struct {
	*responses.BaseResponse
	RequestId                string `json:"RequestId" xml:"RequestId"`
	TranscodeTemplateGroupId string `json:"TranscodeTemplateGroupId" xml:"TranscodeTemplateGroupId"`
}

// CreateUpdateTranscodeTemplateGroupRequest creates a request to invoke UpdateTranscodeTemplateGroup API
func CreateUpdateTranscodeTemplateGroupRequest() (request *UpdateTranscodeTemplateGroupRequest) {
	request = &UpdateTranscodeTemplateGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "UpdateTranscodeTemplateGroup", "vod", "openAPI")
	return
}

// CreateUpdateTranscodeTemplateGroupResponse creates a response to parse from UpdateTranscodeTemplateGroup response
func CreateUpdateTranscodeTemplateGroupResponse() (response *UpdateTranscodeTemplateGroupResponse) {
	response = &UpdateTranscodeTemplateGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
