package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteNqa invokes the vpc.DeleteNqa API synchronously
// api document: https://help.aliyun.com/api/vpc/deletenqa.html
func (client *Client) DeleteNqa(request *DeleteNqaRequest) (response *DeleteNqaResponse, err error) {
	response = CreateDeleteNqaResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteNqaWithChan invokes the vpc.DeleteNqa API asynchronously
// api document: https://help.aliyun.com/api/vpc/deletenqa.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteNqaWithChan(request *DeleteNqaRequest) (<-chan *DeleteNqaResponse, <-chan error) {
	responseChan := make(chan *DeleteNqaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteNqa(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteNqaWithCallback invokes the vpc.DeleteNqa API asynchronously
// api document: https://help.aliyun.com/api/vpc/deletenqa.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteNqaWithCallback(request *DeleteNqaRequest, callback func(response *DeleteNqaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteNqaResponse
		var err error
		defer close(result)
		response, err = client.DeleteNqa(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteNqaRequest is the request struct for api DeleteNqa
type DeleteNqaRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	NqaId                string           `position:"Query" name:"NqaId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteNqaResponse is the response struct for api DeleteNqa
type DeleteNqaResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteNqaRequest creates a request to invoke DeleteNqa API
func CreateDeleteNqaRequest() (request *DeleteNqaRequest) {
	request = &DeleteNqaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DeleteNqa", "vpc", "openAPI")
	return
}

// CreateDeleteNqaResponse creates a response to parse from DeleteNqa response
func CreateDeleteNqaResponse() (response *DeleteNqaResponse) {
	response = &DeleteNqaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
