package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePhysicalConnectionOrder invokes the vpc.DescribePhysicalConnectionOrder API synchronously
// api document: https://help.aliyun.com/api/vpc/describephysicalconnectionorder.html
func (client *Client) DescribePhysicalConnectionOrder(request *DescribePhysicalConnectionOrderRequest) (response *DescribePhysicalConnectionOrderResponse, err error) {
	response = CreateDescribePhysicalConnectionOrderResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePhysicalConnectionOrderWithChan invokes the vpc.DescribePhysicalConnectionOrder API asynchronously
// api document: https://help.aliyun.com/api/vpc/describephysicalconnectionorder.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribePhysicalConnectionOrderWithChan(request *DescribePhysicalConnectionOrderRequest) (<-chan *DescribePhysicalConnectionOrderResponse, <-chan error) {
	responseChan := make(chan *DescribePhysicalConnectionOrderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePhysicalConnectionOrder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePhysicalConnectionOrderWithCallback invokes the vpc.DescribePhysicalConnectionOrder API asynchronously
// api document: https://help.aliyun.com/api/vpc/describephysicalconnectionorder.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribePhysicalConnectionOrderWithCallback(request *DescribePhysicalConnectionOrderRequest, callback func(response *DescribePhysicalConnectionOrderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePhysicalConnectionOrderResponse
		var err error
		defer close(result)
		response, err = client.DescribePhysicalConnectionOrder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePhysicalConnectionOrderRequest is the request struct for api DescribePhysicalConnectionOrder
type DescribePhysicalConnectionOrderRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	PhysicalConnectionId string           `position:"Query" name:"PhysicalConnectionId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribePhysicalConnectionOrderResponse is the response struct for api DescribePhysicalConnectionOrder
type DescribePhysicalConnectionOrderResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	InstanceId string `json:"InstanceId" xml:"InstanceId"`
	OrderId    string `json:"OrderId" xml:"OrderId"`
}

// CreateDescribePhysicalConnectionOrderRequest creates a request to invoke DescribePhysicalConnectionOrder API
func CreateDescribePhysicalConnectionOrderRequest() (request *DescribePhysicalConnectionOrderRequest) {
	request = &DescribePhysicalConnectionOrderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DescribePhysicalConnectionOrder", "vpc", "openAPI")
	return
}

// CreateDescribePhysicalConnectionOrderResponse creates a response to parse from DescribePhysicalConnectionOrder response
func CreateDescribePhysicalConnectionOrderResponse() (response *DescribePhysicalConnectionOrderResponse) {
	response = &DescribePhysicalConnectionOrderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
