/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common.ui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.modules.payara.common.PayaraInstance;
import org.netbeans.modules.payara.common.PayaraLogger;
import org.netbeans.modules.payara.common.ui.JavaPlatformsComboBox;
import org.netbeans.modules.payara.common.utils.JavaUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class JavaSEPlatformPanel
extends JPanel {
    private static final Logger LOGGER = PayaraLogger.get(JavaSEPlatformPanel.class);
    private final PayaraInstance instance;
    private final String message;
    private final String javaLabelText;
    private final String propertiesLabelText;
    private final String platformButtonText;
    private final PlatformAction platformButtonAction;
    JavaPlatform[] javaPlatforms;
    private final NotifyDescriptor descriptor;
    private JComboBox javaComboBox;
    private JLabel javaLabel;
    private JLabel messageLabel;
    private JButton platformButton;
    private JCheckBox propertiesCheckBox;
    private JLabel propertiesLabel;

    private void setDescriptorButtons(NotifyDescriptor descriptor, JavaPlatform[] javaPlatforms) {
        if (javaPlatforms == null || javaPlatforms.length == 0) {
            descriptor.setOptions(new Object[]{NotifyDescriptor.CANCEL_OPTION});
        } else {
            descriptor.setOptions(new Object[]{NotifyDescriptor.OK_OPTION, NotifyDescriptor.CANCEL_OPTION});
        }
    }

    public static FileObject selectServerSEPlatform(PayaraInstance instance, File javaHome) {
        Iterator platformIterator;
        FileObject selectedJavaHome = null;
        JavaPlatform platform = JavaUtils.findInstalledPlatform(javaHome);
        String platformName = platform != null ? platform.getDisplayName() : javaHome.getAbsolutePath();
        String message = NbBundle.getMessage(JavaSEPlatformPanel.class, (String)"JavaSEPlatformPanel.warning", (Object)platformName);
        String title = NbBundle.getMessage(JavaSEPlatformPanel.class, (String)"JavaSEPlatformPanel.title", (Object)platformName);
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor(null, title, 2, -1, null, null);
        JavaSEPlatformPanel panel = new JavaSEPlatformPanel(notifyDescriptor, instance, message);
        Object button = DialogDisplayer.getDefault().notify(notifyDescriptor);
        if (button == NotifyDescriptor.CANCEL_OPTION) {
            return selectedJavaHome;
        }
        JavaPlatform selectedPlatform = panel.javaPlatform();
        if (selectedPlatform != null && (platformIterator = selectedPlatform.getInstallFolders().iterator()).hasNext()) {
            selectedJavaHome = (FileObject)platformIterator.next();
        }
        if (selectedJavaHome != null && panel.updateProperties()) {
            instance.setJavaHome(panel.isJavaPlatformDefault() ? null : FileUtil.toFile((FileObject)selectedJavaHome).getAbsolutePath());
            try {
                PayaraInstance.writeInstanceToFile(instance);
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, "Could not store Payara server attributes", ex);
            }
        }
        return selectedJavaHome;
    }

    public JavaSEPlatformPanel(NotifyDescriptor descriptor, PayaraInstance instance, String message) {
        this.descriptor = descriptor;
        this.instance = instance;
        this.message = message;
        this.javaLabelText = NbBundle.getMessage(JavaSEPlatformPanel.class, (String)"JavaSEPlatformPanel.javaLabel");
        this.propertiesLabelText = NbBundle.getMessage(JavaSEPlatformPanel.class, (String)"JavaSEPlatformPanel.propertiesLabel");
        this.platformButtonText = NbBundle.getMessage(JavaSEPlatformPanel.class, (String)"JavaSEPlatformPanel.platformButton");
        this.platformButtonAction = new PlatformAction();
        this.javaPlatforms = JavaUtils.findSupportedPlatforms(instance);
        descriptor.setMessage((Object)this);
        this.setDescriptorButtons(this.descriptor, this.javaPlatforms);
        this.initComponents();
    }

    boolean updateProperties() {
        return this.propertiesCheckBox.isSelected();
    }

    JavaPlatform javaPlatform() {
        JavaPlatformsComboBox.Platform platform = (JavaPlatformsComboBox.Platform)this.javaComboBox.getSelectedItem();
        return platform != null ? platform.getPlatform() : null;
    }

    boolean isJavaPlatformDefault() {
        JavaPlatformsComboBox.Platform platform = (JavaPlatformsComboBox.Platform)this.javaComboBox.getSelectedItem();
        return platform != null ? platform.isDefault() : false;
    }

    private void initComponents() {
        this.messageLabel = new JLabel();
        this.javaComboBox = new JavaPlatformsComboBox(this.javaPlatforms);
        this.javaLabel = new JLabel();
        this.propertiesLabel = new JLabel();
        this.propertiesCheckBox = new JCheckBox();
        this.platformButton = new JButton(this.platformButtonAction);
        this.setMaximumSize(new Dimension(500, 200));
        this.setMinimumSize(new Dimension(500, 150));
        this.setName("");
        this.setPreferredSize(new Dimension(500, 150));
        Mnemonics.setLocalizedText((JLabel)this.messageLabel, (String)this.message);
        Mnemonics.setLocalizedText((JLabel)this.javaLabel, (String)this.javaLabelText);
        Mnemonics.setLocalizedText((JLabel)this.propertiesLabel, (String)this.propertiesLabelText);
        this.propertiesCheckBox.setSelected(true);
        this.propertiesCheckBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        Mnemonics.setLocalizedText((AbstractButton)this.platformButton, (String)this.platformButtonText);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.messageLabel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.javaLabel).addComponent(this.propertiesLabel, GroupLayout.Alignment.TRAILING)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.javaComboBox, 0, 232, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.platformButton)).addGroup(layout.createSequentialGroup().addComponent(this.propertiesCheckBox).addGap(0, 0, Short.MAX_VALUE))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.messageLabel, -2, 67, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.javaLabel).addComponent(this.javaComboBox, -2, -1, -2).addComponent(this.platformButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.propertiesCheckBox).addComponent(this.propertiesLabel)).addContainerGap(13, Short.MAX_VALUE)));
    }

    private class PlatformAction
    extends AbstractAction {
        private PlatformAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PlatformsCustomizer.showCustomizer((JavaPlatform)JavaSEPlatformPanel.this.javaPlatform());
            JavaSEPlatformPanel.this.javaPlatforms = JavaUtils.findSupportedPlatforms(JavaSEPlatformPanel.this.instance);
            ((JavaPlatformsComboBox)JavaSEPlatformPanel.this.javaComboBox).updateModel(JavaSEPlatformPanel.this.javaPlatforms);
            JavaSEPlatformPanel.this.setDescriptorButtons(JavaSEPlatformPanel.this.descriptor, JavaSEPlatformPanel.this.javaPlatforms);
        }
    }
}

