/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.apisupport;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.apisupport.Bundle;
import org.netbeans.modules.maven.apisupport.MavenNbModuleImpl;
import org.netbeans.modules.maven.apisupport.RunIDEInstallationChecker;
import org.netbeans.spi.project.ui.ProjectProblemResolver;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

public class MissingNbInstallationProblemProvider
implements ProjectProblemsProvider {
    private final Project project;
    private final PropertyChangeSupport pchs = new PropertyChangeSupport(this);
    private final PropertyChangeListener propertyListener;
    private final PropertyChangeListener weak;

    public MissingNbInstallationProblemProvider(Project prj) {
        this.project = prj;
        this.propertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("openProjects".equals(evt.getPropertyName()) && OpenProjects.getDefault().isProjectOpen(MissingNbInstallationProblemProvider.this.project)) {
                    MissingNbInstallationProblemProvider.this.pchs.firePropertyChange("problems", null, null);
                }
                if ("MavenProject".equals(evt.getPropertyName())) {
                    MissingNbInstallationProblemProvider.this.pchs.firePropertyChange("problems", null, null);
                }
            }
        };
        this.weak = WeakListeners.propertyChange((PropertyChangeListener)this.propertyListener, (Object)this);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pchs.addPropertyChangeListener(listener);
        if (this.pchs.getPropertyChangeListeners().length == 1) {
            NbMavenProject.addPropertyChangeListener((Project)this.project, (PropertyChangeListener)this.propertyListener);
            OpenProjects.getDefault().addPropertyChangeListener(this.weak);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pchs.removePropertyChangeListener(listener);
        if (this.pchs.getPropertyChangeListeners().length == 0) {
            NbMavenProject.removePropertyChangeListener((Project)this.project, (PropertyChangeListener)this.propertyListener);
            OpenProjects.getDefault().removePropertyChangeListener(this.weak);
        }
    }

    public Collection<? extends ProjectProblemsProvider.ProjectProblem> getProblems() {
        File install;
        Project parent = MavenNbModuleImpl.findAppProject(this.project);
        if (!(parent != null || (install = MavenNbModuleImpl.findIDEInstallation(this.project)) != null && install.exists())) {
            return Collections.singleton(ProjectProblemsProvider.ProjectProblem.createWarning((String)Bundle.TIT_Missing_platform(), (String)Bundle.DESC_Missing_platform(), (ProjectProblemResolver)new ProjectProblemResolverImpl(this.project)));
        }
        return Collections.emptySet();
    }

    private static class ProjectProblemResolverImpl
    implements ProjectProblemResolver {
        private final Project project;

        public ProjectProblemResolverImpl(Project p) {
            this.project = p;
        }

        public Future<ProjectProblemsProvider.Result> resolve() {
            FutureTask<ProjectProblemsProvider.Result> toRet = new FutureTask<ProjectProblemsProvider.Result>(new Callable<ProjectProblemsProvider.Result>(){

                @Override
                public ProjectProblemsProvider.Result call() throws Exception {
                    Action act;
                    NotifyDescriptor.Confirmation action = new NotifyDescriptor.Confirmation((Object)"You can either define netbeans.installation property in .m2/settings.xml file to point to currently running IDE or open the associated nbm-application project.", "Resolve missing NetBeans platform");
                    String prop = "Define property";
                    String open = "Open Application project";
                    action.setOptions(new Object[]{prop, open, NotifyDescriptor.CANCEL_OPTION});
                    Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)action);
                    if (prop.equals(result)) {
                        RunIDEInstallationChecker.setRunningIDEAsInstallation();
                        return ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.RESOLVED);
                    }
                    if (open.equals(result) && (act = (Action)FileUtil.getConfigObject((String)"Actions/Project/org-netbeans-modules-project-ui-OpenProject.instance", Action.class)) != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                act.actionPerformed(null);
                            }
                        });
                    }
                    return ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED);
                }
            });
            toRet.run();
            return toRet;
        }

        public int hashCode() {
            int hash = MissingNbInstallationProblemProvider.class.hashCode();
            hash = 73 * hash + (this.project != null ? this.project.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProjectProblemResolverImpl other = (ProjectProblemResolverImpl)obj;
            return this.project == other.project || this.project != null && this.project.equals(other.project);
        }
    }
}

