/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.filters;

import java.util.Locale;
import java.util.Properties;
import java.util.regex.Pattern;
import org.netbeans.lib.profiler.filters.GenericFilter;

public class TextFilter
extends GenericFilter {
    public static final int TYPE_REGEXP = 30;
    private static final String[] NORMALIZED_NOT_READY = new String[0];
    private String[] normalizedValues = NORMALIZED_NOT_READY;
    private transient Pattern[] regexpPatterns;

    public TextFilter() {
        super(null, "", 10);
    }

    public TextFilter(String value, int type, boolean caseSensitive) {
        super(null, value, type);
        this.setCaseSensitive(caseSensitive);
    }

    public TextFilter(Properties properties, String id) {
        super(properties, id);
    }

    public void copyFrom(TextFilter other) {
        super.copyFrom(other);
        this.normalizedValues = other.normalizedValues;
        this.regexpPatterns = other.regexpPatterns;
    }

    @Override
    public boolean isAll() {
        return this.isEmpty();
    }

    public final void setCaseSensitive(boolean caseSensitive) {
        this.normalizedValues = caseSensitive || this.getType() == 30 ? null : NORMALIZED_NOT_READY;
    }

    public final boolean isCaseSensitive() {
        return this.normalizedValues == null;
    }

    @Override
    protected void valueChanged() {
        super.valueChanged();
        if (!this.isCaseSensitive()) {
            this.normalizedValues = NORMALIZED_NOT_READY;
        }
        this.regexpPatterns = null;
    }

    @Override
    public boolean passes(String string) {
        if (this.getType() == 30) {
            String[] values = this.getValues();
            if (this.regexpPatterns == null) {
                this.regexpPatterns = new Pattern[values.length];
            }
            for (int i = 0; i < this.regexpPatterns.length; ++i) {
                if (this.regexpPatterns[i] == null) {
                    try {
                        this.regexpPatterns[i] = Pattern.compile(values[i]);
                    }
                    catch (RuntimeException e) {
                        this.handleInvalidFilter(values[i], e);
                        this.regexpPatterns[i] = Pattern.compile(".*");
                    }
                }
                if (!this.regexpPatterns[i].matcher(string).matches()) continue;
                return true;
            }
            return false;
        }
        if (this.simplePasses(string)) {
            return true;
        }
        String[] values = this.getValues();
        boolean caseSensitive = this.isCaseSensitive();
        if (!caseSensitive) {
            string = TextFilter.normalizeString(string);
            if (this.normalizedValues == NORMALIZED_NOT_READY) {
                this.normalizedValues = new String[values.length];
            }
        }
        for (int i = 0; i < values.length; ++i) {
            String value;
            if (!caseSensitive) {
                if (this.normalizedValues[i] == null) {
                    this.normalizedValues[i] = TextFilter.normalizeString(values[i]);
                }
                value = this.normalizedValues[i];
            } else {
                value = values[i];
            }
            if (!string.contains(value)) continue;
            return this.getType() == 10;
        }
        return this.getType() != 10;
    }

    protected void handleInvalidFilter(String invalidValue, RuntimeException e) {
    }

    private static String normalizeString(String string) {
        return string.toLowerCase(Locale.ENGLISH);
    }

    @Override
    protected boolean valuesEquals(Object obj) {
        if (!super.valuesEquals(obj)) {
            return false;
        }
        TextFilter other = (TextFilter)obj;
        return !(this.normalizedValues == null ? other.normalizedValues != null : other.normalizedValues == null);
    }

    @Override
    protected int valuesHashCode(int hashBase) {
        hashBase = super.valuesHashCode(hashBase);
        if (this.normalizedValues == null) {
            hashBase = 67 * hashBase;
        }
        return hashBase;
    }
}

