/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.memorylint;

import java.util.List;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.PrimitiveArrayInstance;
import org.netbeans.modules.profiler.heapwalk.memorylint.FieldAccess;

public class StringHelper {
    private FieldAccess fldCount;
    private FieldAccess fldOffset;
    private FieldAccess fldValue;
    private Heap heap;
    private JavaClass clsString;

    StringHelper(Heap heap) {
        this.heap = heap;
        this.clsString = heap.getJavaClassByName("java.lang.String");
        this.fldOffset = new FieldAccess(this.clsString, "offset");
        this.fldCount = new FieldAccess(this.clsString, "count");
        this.fldValue = new FieldAccess(this.clsString, "value");
    }

    public String decodeString(Instance in) {
        if (in == null) {
            return "null";
        }
        if (!"java.lang.String".equals(in.getJavaClass().getName())) {
            return "<<" + in.getJavaClass().getName() + ">>";
        }
        int off = this.fldOffset.getIntValue(in);
        int cnt = this.fldCount.getIntValue(in);
        PrimitiveArrayInstance arrValue = (PrimitiveArrayInstance)this.fldValue.getRefValue(in);
        if (arrValue == null) {
            return "";
        }
        char[] data = this.getCharArray(arrValue);
        return new String(data, off, cnt);
    }

    private char[] getCharArray(PrimitiveArrayInstance in) {
        List vals = in.getValues();
        char[] ret = new char[in.getLength()];
        assert (ret.length == vals.size());
        int i = 0;
        for (String v : vals) {
            ret[i++] = v.charAt(0);
        }
        return ret;
    }
}

