/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform;

import java.io.File;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.ant.freeform.FreeformProject;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.queries.SharabilityQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FreeformSharabilityQuery
implements SharabilityQueryImplementation2,
AntProjectListener {
    private String nbproject;
    private String nbprojectPrivate;
    private volatile Set<File> exported;
    private final FreeformProject project;

    public FreeformSharabilityQuery(FreeformProject project) {
        assert (project != null);
        this.project = project;
        AntProjectHelper helper = project.helper();
        this.nbproject = helper.resolveFile("nbproject").getAbsolutePath();
        this.nbprojectPrivate = helper.resolveFile("nbproject/private").getAbsolutePath();
        helper.addAntProjectListener((AntProjectListener)this);
    }

    public SharabilityQuery.Sharability getSharability(URI uri) {
        File file = Utilities.toFile((URI)uri);
        String absolutePath = file.getAbsolutePath();
        if (absolutePath.equals(this.nbproject)) {
            return SharabilityQuery.Sharability.MIXED;
        }
        if (absolutePath.startsWith(this.nbproject)) {
            return absolutePath.startsWith(this.nbprojectPrivate) ? SharabilityQuery.Sharability.NOT_SHARABLE : SharabilityQuery.Sharability.SHARABLE;
        }
        if (this.isExported(file)) {
            return SharabilityQuery.Sharability.NOT_SHARABLE;
        }
        return SharabilityQuery.Sharability.UNKNOWN;
    }

    public void configurationXmlChanged(AntProjectEvent ev) {
        this.exported = null;
    }

    public void propertiesChanged(AntProjectEvent ev) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isExported(File file) {
        Set<File> _exported = this.exported;
        if (_exported == null) {
            _exported = new HashSet<File>();
            final HashSet<File> _exportedFinal = _exported;
            ProjectManager.mutex().readAccess(new Runnable(){

                @Override
                public void run() {
                    Element root = FreeformSharabilityQuery.this.project.getPrimaryConfigurationData();
                    NodeList exports = root.getElementsByTagNameNS("http://www.netbeans.org/ns/freeform-project/2", "export");
                    for (int i = 0; i < exports.getLength(); ++i) {
                        File exportedFile;
                        String path;
                        Element export = (Element)exports.item(i);
                        Element location = XMLUtil.findElement((Element)export, (String)"location", (String)"http://www.netbeans.org/ns/freeform-project/2");
                        if (location == null || (path = XMLUtil.findText((Node)location)) == null || (exportedFile = Util.resolveFile(FreeformSharabilityQuery.this.project.evaluator(), FileUtil.toFile((FileObject)FreeformSharabilityQuery.this.project.getProjectDirectory()), path)) == null) continue;
                        _exportedFinal.add(exportedFile);
                    }
                }
            });
            FreeformSharabilityQuery freeformSharabilityQuery = this;
            synchronized (freeformSharabilityQuery) {
                if (this.exported == null) {
                    this.exported = _exported;
                }
            }
        }
        return _exported.contains(file);
    }
}

