/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.freeform;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.modules.java.freeform.Classpaths;
import org.netbeans.modules.java.freeform.JavaProjectGenerator;
import org.netbeans.modules.java.freeform.jdkselection.JdkConfiguration;
import org.netbeans.modules.java.freeform.ui.ProjectModel;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class JavaActions
implements ActionProvider {
    static final String JAVA_FILE_PATTERN = "\\.java$";
    private static final String[] ACTIONS = new String[]{"compile.single", "debug", "profile", "run.single", "debug.single", "profile.single"};
    static final String FILE_SCRIPT_PATH = "nbproject/ide-file-targets.xml";
    static final String GENERAL_SCRIPT_PATH = "nbproject/ide-targets.xml";
    private final Project project;
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private final AuxiliaryConfiguration aux;
    private boolean setOutputsNotified;
    private static final String[] DEBUG_VM_ARGS = new String[]{"-agentlib:jdwp=transport=dt_socket,address=${jpda.address}"};
    private static final String[] rootElementsOrder = new String[]{"name", "properties", "folders", "ide-actions", "export", "view", "subprojects"};

    public JavaActions(Project project, AntProjectHelper helper, PropertyEvaluator evaluator, AuxiliaryConfiguration aux) {
        this.project = project;
        this.helper = helper;
        this.evaluator = evaluator;
        this.aux = aux;
    }

    public String[] getSupportedActions() {
        return ACTIONS;
    }

    public boolean isActionEnabled(String command, Lookup context) throws IllegalArgumentException {
        if (command.equals("compile.single")) {
            return this.findPackageRoot(context) != null;
        }
        if (command.equals("debug")) {
            return true;
        }
        if (command.equals("profile")) {
            return true;
        }
        if (command.equals("run.single")) {
            return this.findPackageRoot(context) != null && this.isSingleJavaFileSelected(context);
        }
        if (command.equals("debug.single")) {
            return this.findPackageRoot(context) != null && this.isSingleJavaFileSelected(context);
        }
        if (command.equals("profile.single")) {
            return this.findPackageRoot(context) != null && this.isSingleJavaFileSelected(context);
        }
        throw new IllegalArgumentException(command);
    }

    public void invokeAction(final String command, final Lookup context) throws IllegalArgumentException {
        try {
            this.project.getProjectDirectory().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    block8: {
                        try {
                            if (command.equals("compile.single")) {
                                JavaActions.this.handleCompileSingle(context);
                                break block8;
                            }
                            if (command.equals("debug")) {
                                JavaActions.this.handleDebug();
                                break block8;
                            }
                            if (command.equals("profile")) {
                                JavaActions.this.handleProfile();
                                break block8;
                            }
                            if (command.equals("run.single")) {
                                JavaActions.this.handleRunSingle(context);
                                break block8;
                            }
                            if (command.equals("debug.single")) {
                                JavaActions.this.handleDebugSingle(context);
                                break block8;
                            }
                            if (command.equals("profile.single")) {
                                JavaActions.this.handleProfileSingle(context);
                                break block8;
                            }
                            throw new IllegalArgumentException(command);
                        }
                        catch (SAXException e) {
                            throw (IOException)new IOException(e.toString()).initCause(e);
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private boolean alert(String commandDisplayName, String scriptPath) {
        String projectDisplayName = ProjectUtils.getInformation((Project)this.project).getDisplayName();
        String title = NbBundle.getMessage(JavaActions.class, (String)"TITLE_generate_target_dialog", (Object)commandDisplayName, (Object)projectDisplayName);
        String body = NbBundle.getMessage(JavaActions.class, (String)"TEXT_generate_target_dialog", (Object)commandDisplayName, (Object)scriptPath);
        NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)body, 3);
        d.setTitle(title);
        d.setOptionType(2);
        JButton generate = new JButton(NbBundle.getMessage(JavaActions.class, (String)"LBL_generate"));
        generate.setDefaultCapable(true);
        d.setOptions(new Object[]{generate, NotifyDescriptor.CANCEL_OPTION});
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == generate;
    }

    private boolean alertOutputs(String commandDisplayName) {
        JButton setOutputOption = new JButton(NbBundle.getMessage(JavaActions.class, (String)"CTL_SetOutput"));
        setOutputOption.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavaActions.class, (String)"AD_SetOutput"));
        setOutputOption.setDefaultCapable(true);
        String projectDisplayName = ProjectUtils.getInformation((Project)this.project).getDisplayName();
        String title = NbBundle.getMessage(JavaActions.class, (String)"TITLE_set_outputs_dialog", (Object)commandDisplayName, (Object)projectDisplayName);
        String body = NbBundle.getMessage(JavaActions.class, (String)"TEXT_set_outputs_dialog");
        NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)body, 3);
        d.setTitle(title);
        d.setOptionType(2);
        d.setOptions(new Object[]{setOutputOption, NotifyDescriptor.CANCEL_OPTION});
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == setOutputOption) {
            CustomizerProvider customizerProvider = (CustomizerProvider)this.project.getLookup().lookup(CustomizerProvider.class);
            assert (customizerProvider != null);
            customizerProvider.showCustomizer();
            return true;
        }
        return false;
    }

    private void handleCompileSingle(Lookup context) throws IOException, SAXException {
        if (!this.alert(NbBundle.getMessage(JavaActions.class, (String)"ACTION_compile.single"), FILE_SCRIPT_PATH)) {
            return;
        }
        Document doc = this.readCustomScript(FILE_SCRIPT_PATH);
        this.ensurePropertiesCopied(doc.getDocumentElement());
        Comment comm = doc.createComment(" " + NbBundle.getMessage(JavaActions.class, (String)"COMMENT_edit_target") + " ");
        doc.getDocumentElement().appendChild(comm);
        comm = doc.createComment(" " + NbBundle.getMessage(JavaActions.class, (String)"COMMENT_more_info_x.single") + " ");
        doc.getDocumentElement().appendChild(comm);
        String propertyName = "files";
        AntLocation root = this.findPackageRoot(context);
        assert (root != null) : context;
        Element target = this.createCompileSingleTarget(doc, context, propertyName, root);
        doc.getDocumentElement().appendChild(target);
        this.writeCustomScript(doc, FILE_SCRIPT_PATH);
        String targetName = target.getAttribute("name");
        this.addBinding("compile.single", FILE_SCRIPT_PATH, targetName, propertyName, root.virtual, JAVA_FILE_PATTERN, "relative-path", ",");
        this.jumpToBinding("compile.single");
        this.jumpToBuildScript(FILE_SCRIPT_PATH, targetName);
    }

    Element createCompileSingleTarget(Document doc, Lookup context, String propertyName, AntLocation root) {
        String cp;
        String targetName = "compile-selected-files-in-" + root.physical.getNameExt();
        Element target = doc.createElement("target");
        this.addJdkInitDeps(target);
        target.setAttribute("name", targetName);
        Element fail = doc.createElement("fail");
        fail.setAttribute("unless", propertyName);
        fail.appendChild(doc.createTextNode(NbBundle.getMessage(JavaActions.class, (String)"COMMENT_must_set_property", (Object)propertyName)));
        target.appendChild(fail);
        String classesDir = this.findClassesOutputDir(root.virtual);
        if (classesDir == null) {
            target.appendChild(doc.createComment(" " + NbBundle.getMessage(JavaActions.class, (String)"COMMENT_must_set_build_classes_dir") + " "));
            classesDir = "${build.classes.dir}";
        }
        Element mkdir = doc.createElement("mkdir");
        mkdir.setAttribute("dir", classesDir);
        target.appendChild(mkdir);
        Element javac = doc.createElement("javac");
        javac.setAttribute("srcdir", root.virtual);
        javac.setAttribute("destdir", classesDir);
        javac.setAttribute("includes", "${" + propertyName + "}");
        String sourceLevel = this.findSourceLevel(root.virtual);
        if (sourceLevel != null) {
            javac.setAttribute("source", sourceLevel);
        }
        if ((cp = this.findCUClasspath(root.virtual, "compile")) != null) {
            Element classpath = doc.createElement("classpath");
            classpath.setAttribute("path", cp);
            javac.appendChild(classpath);
        }
        target.appendChild(javac);
        return target;
    }

    private void handleDebug() throws IOException, SAXException {
        Element generatedTarget;
        Document doc;
        String generatedScriptPath;
        if (!this.setOutputsNotified) {
            ProjectModel pm = ProjectModel.createModel(Util.getProjectLocation((AntProjectHelper)this.helper, (PropertyEvaluator)this.evaluator), FileUtil.toFile((FileObject)this.project.getProjectDirectory()), this.evaluator, this.helper);
            List<ProjectModel.CompilationUnitKey> cuKeys = pm.createCompilationUnitKeys();
            assert (cuKeys != null);
            boolean hasOutputs = false;
            for (ProjectModel.CompilationUnitKey ck : cuKeys) {
                JavaProjectGenerator.JavaCompilationUnit cu = pm.getCompilationUnit(ck, false);
                if (cu.output == null || cu.output.size() <= 0) continue;
                hasOutputs = true;
                break;
            }
            if (!hasOutputs) {
                this.alertOutputs(NbBundle.getMessage(JavaActions.class, (String)"ACTION_debug"));
                this.setOutputsNotified = true;
                return;
            }
        }
        String[] bindings = this.findCommandBinding("run");
        Element task = null;
        Element origTarget = null;
        if (bindings != null && bindings.length <= 2 && (origTarget = this.findExistingBuildTarget("run")) != null) {
            task = this.targetUsesTaskExactlyOnce(origTarget, "java");
        }
        if (!this.alert(NbBundle.getMessage(JavaActions.class, (String)"ACTION_debug"), task != null ? GENERAL_SCRIPT_PATH : FILE_SCRIPT_PATH)) {
            return;
        }
        String generatedTargetName = "debug-nb";
        if (task != null) {
            generatedScriptPath = GENERAL_SCRIPT_PATH;
            doc = this.readCustomScript(GENERAL_SCRIPT_PATH);
            this.ensureImports(doc.getDocumentElement(), bindings[0]);
            generatedTarget = this.createDebugTargetFromTemplate(generatedTargetName, origTarget, task, doc);
        } else {
            generatedScriptPath = FILE_SCRIPT_PATH;
            doc = this.readCustomScript(FILE_SCRIPT_PATH);
            this.ensurePropertiesCopied(doc.getDocumentElement());
            generatedTarget = this.createDebugTargetFromScratch(generatedTargetName, doc);
        }
        Comment comm = doc.createComment(" " + NbBundle.getMessage(JavaActions.class, (String)"COMMENT_edit_target") + " ");
        doc.getDocumentElement().appendChild(comm);
        comm = doc.createComment(" " + NbBundle.getMessage(JavaActions.class, (String)"COMMENT_more_info_debug") + " ");
        doc.getDocumentElement().appendChild(comm);
        doc.getDocumentElement().appendChild(generatedTarget);
        this.writeCustomScript(doc, generatedScriptPath);
        this.addBinding("debug", generatedScriptPath, generatedTargetName, null, null, null, null, null);
        this.jumpToBinding("debug");
        this.jumpToBuildScript(generatedScriptPath, generatedTargetName);
    }

    private Element createNbjpdastart(Document ownerDocument) {
        Element nbjpdastart = ownerDocument.createElement("nbjpdastart");
        nbjpdastart.setAttribute("name", ProjectUtils.getInformation((Project)this.project).getDisplayName());
        nbjpdastart.setAttribute("addressproperty", "jpda.address");
        nbjpdastart.setAttribute("transport", "dt_socket");
        return nbjpdastart;
    }

    private void addDebugVMArgs(Element java, Document ownerDocument) {
        int i;
        NamedNodeMap attrs = java.getAttributes();
        boolean found = false;
        for (i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (!"fork".equals(attr.getName())) continue;
            String value = attr.getValue();
            if (!"on".equalsIgnoreCase(value) && !"true".equalsIgnoreCase(value) && !"yes".equalsIgnoreCase(value)) break;
            found = true;
            break;
        }
        if (!found) {
            java.setAttribute("fork", "true");
        }
        for (i = 0; i < DEBUG_VM_ARGS.length; ++i) {
            Element jvmarg = ownerDocument.createElement("jvmarg");
            jvmarg.setAttribute("value", DEBUG_VM_ARGS[i]);
            java.appendChild(jvmarg);
        }
    }

    Element createDebugTargetFromTemplate(String generatedTargetName, Element origTarget, Element origTask, Document ownerDocument) {
        NodeList tasks = origTarget.getChildNodes();
        int taskIndex = -1;
        for (int i = 0; i < tasks.getLength(); ++i) {
            if (tasks.item(i) != origTask) continue;
            taskIndex = i;
            break;
        }
        assert (taskIndex != -1);
        Element target = (Element)ownerDocument.importNode(origTarget, true);
        this.addJdkInitDeps(target);
        Element task = (Element)target.getChildNodes().item(taskIndex);
        target.setAttribute("name", generatedTargetName);
        Element nbjpdastart = this.createNbjpdastart(ownerDocument);
        String textualCp = task.getAttribute("classpath");
        if (textualCp.length() > 0) {
            Element classpath = ownerDocument.createElement("classpath");
            classpath.setAttribute("path", textualCp);
            nbjpdastart.appendChild(classpath);
        } else {
            NodeList origClasspath = task.getElementsByTagName("classpath");
            if (origClasspath.getLength() == 1) {
                Element classpath = (Element)ownerDocument.importNode(origClasspath.item(0), true);
                nbjpdastart.appendChild(classpath);
            }
        }
        target.insertBefore(nbjpdastart, task);
        this.addDebugVMArgs(task, ownerDocument);
        return target;
    }

    Element createDebugTargetFromScratch(String generatedTargetName, Document ownerDocument) {
        Element target = ownerDocument.createElement("target");
        this.addJdkInitDeps(target);
        target.setAttribute("name", generatedTargetName);
        Element path = ownerDocument.createElement("path");
        path.setAttribute("id", "cp");
        path.appendChild(ownerDocument.createComment(" " + NbBundle.getMessage(JavaActions.class, (String)"COMMENT_set_runtime_cp") + " "));
        target.appendChild(path);
        Element nbjpdastart = this.createNbjpdastart(ownerDocument);
        Element classpath = ownerDocument.createElement("classpath");
        classpath.setAttribute("refid", "cp");
        nbjpdastart.appendChild(classpath);
        target.appendChild(nbjpdastart);
        target.appendChild(ownerDocument.createComment(" " + NbBundle.getMessage(JavaActions.class, (String)"COMMENT_set_main_class") + " "));
        Element java = ownerDocument.createElement("java");
        java.setAttribute("classname", "some.main.Class");
        classpath = ownerDocument.createElement("classpath");
        classpath.setAttribute("refid", "cp");
        java.appendChild(classpath);
        this.addDebugVMArgs(java, ownerDocument);
        target.appendChild(java);
        return target;
    }

    private void handleProfile() throws IOException, SAXException {
        Element generatedTarget;
        Document doc;
        String generatedScriptPath;
        if (!this.setOutputsNotified) {
            ProjectModel pm = ProjectModel.createModel(Util.getProjectLocation((AntProjectHelper)this.helper, (PropertyEvaluator)this.evaluator), FileUtil.toFile((FileObject)this.project.getProjectDirectory()), this.evaluator, this.helper);
            List<ProjectModel.CompilationUnitKey> cuKeys = pm.createCompilationUnitKeys();
            assert (cuKeys != null);
            boolean hasOutputs = false;
            for (ProjectModel.CompilationUnitKey ck : cuKeys) {
                JavaProjectGenerator.JavaCompilationUnit cu = pm.getCompilationUnit(ck, false);
                if (cu.output == null || cu.output.size() <= 0) continue;
                hasOutputs = true;
                break;
            }
            if (!hasOutputs) {
                this.alertOutputs(NbBundle.getMessage(JavaActions.class, (String)"ACTION_profile"));
                this.setOutputsNotified = true;
                return;
            }
        }
        String[] bindings = this.findCommandBinding("run");
        Element task = null;
        Element origTarget = null;
        if (bindings != null && bindings.length <= 2 && (origTarget = this.findExistingBuildTarget("run")) != null) {
            task = this.targetUsesTaskExactlyOnce(origTarget, "java");
        }
        if (!this.alert(NbBundle.getMessage(JavaActions.class, (String)"ACTION_profile"), task != null ? GENERAL_SCRIPT_PATH : FILE_SCRIPT_PATH)) {
            return;
        }
        String generatedTargetName = "profile-nb";
        if (task != null) {
            generatedScriptPath = GENERAL_SCRIPT_PATH;
            doc = this.readCustomScript(GENERAL_SCRIPT_PATH);
            this.ensureImports(doc.getDocumentElement(), bindings[0]);
            generatedTarget = this.createProfileTargetFromTemplate(generatedTargetName, origTarget, task, doc);
        } else {
            generatedScriptPath = FILE_SCRIPT_PATH;
            doc = this.readCustomScript(FILE_SCRIPT_PATH);
            this.ensurePropertiesCopied(doc.getDocumentElement());
            generatedTarget = this.createProfileTargetFromScratch(generatedTargetName, doc);
        }
        Comment comm = doc.createComment(" " + NbBundle.getMessage(JavaActions.class, (String)"COMMENT_edit_target") + " ");
        doc.getDocumentElement().appendChild(comm);
        comm = doc.createComment(" " + NbBundle.getMessage(JavaActions.class, (String)"COMMENT_more_info_profile") + " ");
        doc.getDocumentElement().appendChild(comm);
        doc.getDocumentElement().appendChild(generatedTarget);
        this.writeCustomScript(doc, generatedScriptPath);
        this.addBinding("profile", generatedScriptPath, generatedTargetName, null, null, null, null, null);
        this.jumpToBinding("profile");
        this.jumpToBuildScript(generatedScriptPath, generatedTargetName);
    }

    Element createProfileTargetFromTemplate(String generatedTargetName, Element origTarget, Element origTask, Document ownerDocument) {
        NodeList tasks = origTarget.getChildNodes();
        int taskIndex = -1;
        for (int i = 0; i < tasks.getLength(); ++i) {
            if (tasks.item(i) != origTask) continue;
            taskIndex = i;
            break;
        }
        assert (taskIndex != -1);
        Element target = (Element)ownerDocument.importNode(origTarget, true);
        target.setAttribute("depends", "-profile-check");
        target.setAttribute("if", "profiler.configured");
        this.addJdkInitDeps(target);
        Element task = (Element)target.getChildNodes().item(taskIndex);
        target.setAttribute("name", generatedTargetName);
        this.addProfileInit(ownerDocument, ownerDocument.getDocumentElement());
        this.addProfileVMArgs(task, ownerDocument);
        return target;
    }

    Element createProfileTargetFromScratch(String generatedTargetName, Document ownerDocument) {
        Element target = ownerDocument.createElement("target");
        target.setAttribute("depends", "-profile-check");
        target.setAttribute("if", "profiler.configured");
        this.addJdkInitDeps(target);
        target.setAttribute("name", generatedTargetName);
        Element path = ownerDocument.createElement("path");
        path.setAttribute("id", "cp");
        path.appendChild(ownerDocument.createComment(" " + NbBundle.getMessage(JavaActions.class, (String)"COMMENT_set_runtime_cp") + " "));
        target.appendChild(path);
        this.addProfileInit(ownerDocument, ownerDocument.getDocumentElement());
        target.appendChild(ownerDocument.createComment(" " + NbBundle.getMessage(JavaActions.class, (String)"COMMENT_set_main_class") + " "));
        Element java = ownerDocument.createElement("java");
        java.setAttribute("classname", "some.main.Class");
        Element classpath = ownerDocument.createElement("classpath");
        classpath.setAttribute("refid", "cp");
        java.appendChild(classpath);
        this.addProfileVMArgs(java, ownerDocument);
        target.appendChild(java);
        return target;
    }

    private void addProfileInit(Document ownerDocument, Element parent) {
        NodeList nl = ownerDocument.getElementsByTagName("target");
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!"-profile-check".equals(((Element)nl.item(i)).getAttribute("name"))) continue;
            return;
        }
        Element init = ownerDocument.createElement("target");
        init.setAttribute("name", "-profile-check");
        Element profilerStart = ownerDocument.createElement("startprofiler");
        profilerStart.setAttribute("freeform", "true");
        init.appendChild(profilerStart);
        parent.appendChild(init);
    }

    private void addProfileVMArgs(Element java, Document ownerDocument) {
        NamedNodeMap attrs = java.getAttributes();
        boolean found = false;
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (!"fork".equals(attr.getName())) continue;
            String value = attr.getValue();
            if (!"on".equalsIgnoreCase(value) && !"true".equalsIgnoreCase(value) && !"yes".equalsIgnoreCase(value)) break;
            found = true;
            break;
        }
        if (!found) {
            java.setAttribute("fork", "true");
        }
        Element jvmarg = ownerDocument.createElement("jvmarg");
        jvmarg.setAttribute("line", "${agent.jvmargs}");
        java.appendChild(jvmarg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Document readCustomScript(String scriptPath) throws IOException, SAXException {
        Document doc;
        FileObject script = this.helper.getProjectDirectory().getFileObject(scriptPath);
        if (script != null) {
            try (InputStream is = script.getInputStream();){
                doc = XMLUtil.parse((InputSource)new InputSource(is), (boolean)false, (boolean)true, null, null);
            }
        } else {
            doc = XMLUtil.createDocument((String)"project", null, null, null);
            Element root = doc.getDocumentElement();
            String projname = ProjectUtils.getInformation((Project)this.project).getDisplayName();
            root.setAttribute("name", NbBundle.getMessage(JavaActions.class, (String)"LBL_generated_script_name", (Object)projname));
        }
        if (this.helper.getProjectDirectory().getFileObject("nbproject/jdk.xml") != null) {
            JdkConfiguration.insertJdkXmlImport(doc);
        }
        return doc;
    }

    void ensurePropertiesCopied(Element antProject) {
        if (antProject.getAttribute("basedir").length() > 0) {
            return;
        }
        antProject.setAttribute("basedir", "..");
        Element data = Util.getPrimaryConfigurationData((AntProjectHelper)this.helper);
        Element properties = XMLUtil.findElement((Element)data, (String)"properties", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (properties != null) {
            for (Element el : XMLUtil.findSubElements((Element)properties)) {
                Element nue = antProject.getOwnerDocument().createElement("property");
                if (el.getLocalName().equals("property")) {
                    String name = el.getAttribute("name");
                    assert (name != null);
                    String text = XMLUtil.findText((Node)el);
                    assert (text != null);
                    nue.setAttribute("name", name);
                    nue.setAttribute("value", text);
                } else if (el.getLocalName().equals("property-file")) {
                    String text = XMLUtil.findText((Node)el);
                    assert (text != null);
                    nue.setAttribute("file", text);
                } else assert (false) : el;
                antProject.appendChild(nue);
            }
        }
    }

    void ensureImports(Element antProject, String origScriptPath) throws IOException, SAXException {
        Object basedir;
        Object importPath;
        File origScript;
        if (antProject.getAttribute("basedir").length() > 0) {
            return;
        }
        String origScriptPathEval = this.evaluator.evaluate(origScriptPath);
        if (origScriptPathEval == null) {
            return;
        }
        String origScriptURI = Utilities.toURI((File)this.helper.resolveFile(origScriptPathEval)).toString();
        Document origScriptDocument = XMLUtil.parse((InputSource)new InputSource(origScriptURI), (boolean)false, (boolean)true, null, null);
        String origBasedir = origScriptDocument.getDocumentElement().getAttribute("basedir");
        if (origBasedir.length() == 0) {
            origBasedir = ".";
        }
        if ((origScript = new File(origScriptPathEval)).isAbsolute()) {
            importPath = origScriptPathEval;
            basedir = new File(origBasedir).isAbsolute() ? origBasedir : PropertyUtils.resolveFile((File)origScript.getParentFile(), (String)origBasedir).getAbsolutePath();
        } else {
            String prefix = "../";
            importPath = prefix + origScriptPathEval;
            if (new File(origBasedir).isAbsolute()) {
                basedir = origBasedir;
            } else {
                int slash = origScriptPathEval.replace(File.separatorChar, '/').lastIndexOf(47);
                basedir = slash == -1 ? prefix + origBasedir : prefix + origScriptPathEval.substring(0, slash + 1) + origBasedir;
                basedir = ((String)basedir).replaceAll("/\\.$", "");
            }
        }
        antProject.setAttribute("basedir", (String)basedir);
        Element importEl = antProject.getOwnerDocument().createElement("import");
        importEl.setAttribute("file", (String)importPath);
        antProject.appendChild(importEl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeCustomScript(Document doc, String scriptPath) throws IOException {
        FileObject script = this.helper.getProjectDirectory().getFileObject(scriptPath);
        if (script == null) {
            script = FileUtil.createData((FileObject)this.helper.getProjectDirectory(), (String)scriptPath);
        }
        FileLock lock = script.lock();
        try (OutputStream os = script.getOutputStream(lock);){
            XMLUtil.write((Document)doc, (OutputStream)os, (String)"UTF-8");
        }
        finally {
            lock.releaseLock();
        }
    }

    private List<Element> compilationUnits() {
        Element java = this.aux.getConfigurationFragment("java-data", "http://www.netbeans.org/ns/freeform-project-java/5", true);
        if (java == null) {
            return Collections.emptyList();
        }
        return XMLUtil.findSubElements((Element)java);
    }

    AntLocation findPackageRoot(Lookup context) {
        for (Element compilationUnitEl : this.compilationUnits()) {
            assert (compilationUnitEl.getLocalName().equals("compilation-unit")) : compilationUnitEl;
            List<String> packageRootNames = Classpaths.findPackageRootNames(compilationUnitEl);
            Map<String, FileObject> packageRootsByName = Classpaths.findPackageRootsByName(this.helper, this.evaluator, packageRootNames);
            for (Map.Entry<String, FileObject> entry : packageRootsByName.entrySet()) {
                FileObject root = entry.getValue();
                if (!JavaActions.containsSelectedJavaSources(root, context)) continue;
                return new AntLocation(entry.getKey(), root);
            }
        }
        return null;
    }

    static boolean containsSelectedJavaSources(FileObject root, Lookup context) {
        HashSet<FileObject> selection = new HashSet<FileObject>();
        for (DataObject dob : context.lookupAll(DataObject.class)) {
            selection.add(dob.getPrimaryFile());
        }
        if (selection.isEmpty()) {
            return false;
        }
        for (FileObject f : selection) {
            if (f.isData() && !f.hasExt("java")) {
                return false;
            }
            if (f == root || FileUtil.isParentOf((FileObject)root, (FileObject)f)) continue;
            return false;
        }
        return true;
    }

    private Element findCompilationUnit(String sources) {
        for (Element compilationUnitEl : this.compilationUnits()) {
            for (Element packageRoot : XMLUtil.findSubElements((Element)compilationUnitEl)) {
                if (!packageRoot.getLocalName().equals("package-root") || !XMLUtil.findText((Node)packageRoot).equals(sources)) continue;
                return compilationUnitEl;
            }
        }
        return null;
    }

    String findClassesOutputDir(String sources) {
        Element compilationUnitEl = this.findCompilationUnit(sources);
        if (compilationUnitEl != null) {
            return this.findClassesOutputDir(compilationUnitEl);
        }
        return null;
    }

    private String findClassesOutputDir(Element compilationUnitEl) {
        for (Element builtTo : XMLUtil.findSubElements((Element)compilationUnitEl)) {
            URL destU;
            String rawtext;
            String evaltext;
            if (!builtTo.getLocalName().equals("built-to") || (evaltext = this.evaluator.evaluate(rawtext = XMLUtil.findText((Node)builtTo))) == null) continue;
            File dest = this.helper.resolveFile(evaltext);
            try {
                destU = Utilities.toURI((File)dest).toURL();
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
            if (FileUtil.isArchiveFile((URL)destU)) continue;
            return rawtext;
        }
        return null;
    }

    String findSourceLevel(String sources) {
        Element sourceLevel;
        Element compilationUnitEl = this.findCompilationUnit(sources);
        if (compilationUnitEl != null && (sourceLevel = XMLUtil.findElement((Element)compilationUnitEl, (String)"source-level", (String)"http://www.netbeans.org/ns/freeform-project-java/5")) != null) {
            return XMLUtil.findText((Node)sourceLevel);
        }
        return null;
    }

    String findCUClasspath(String sources, String moud) {
        Element compilationUnitEl = this.findCompilationUnit(sources);
        if (compilationUnitEl != null) {
            for (Element classpath : XMLUtil.findSubElements((Element)compilationUnitEl)) {
                String mode;
                if (!classpath.getLocalName().equals("classpath") || !(mode = classpath.getAttribute("mode")).equals(moud)) continue;
                return XMLUtil.findText((Node)classpath);
            }
        }
        return null;
    }

    private String[] findCUOutputs(String srcRoot) {
        ArrayList<String> outputs = new ArrayList<String>();
        Element cuElem = this.findCompilationUnit(srcRoot);
        if (cuElem != null) {
            NodeList builts = cuElem.getElementsByTagName("built-to");
            for (int i = 0; i < builts.getLength(); ++i) {
                outputs.add(builts.item(i).getTextContent());
            }
        }
        return outputs.toArray(new String[0]);
    }

    void addBinding(String command, String scriptPath, String target, String propertyName, String dir, String pattern, String format, String separator) throws IOException {
        Element data = Util.getPrimaryConfigurationData((AntProjectHelper)this.helper);
        Element ideActions = XMLUtil.findElement((Element)data, (String)"ide-actions", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (ideActions == null) {
            ideActions = data.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/freeform-project/2", "ide-actions");
            XMLUtil.appendChildElement((Element)data, (Element)ideActions, (String[])rootElementsOrder);
        }
        Document doc = data.getOwnerDocument();
        Element action = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "action");
        action.setAttribute("name", command);
        Element script = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "script");
        script.appendChild(doc.createTextNode(scriptPath));
        action.appendChild(script);
        Element targetEl = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "target");
        targetEl.appendChild(doc.createTextNode(target));
        action.appendChild(targetEl);
        if (propertyName != null) {
            Element context = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "context");
            Element property = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "property");
            property.appendChild(doc.createTextNode(propertyName));
            context.appendChild(property);
            Element folder = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "folder");
            folder.appendChild(doc.createTextNode(dir));
            context.appendChild(folder);
            if (pattern != null) {
                Element patternEl = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "pattern");
                patternEl.appendChild(doc.createTextNode(pattern));
                context.appendChild(patternEl);
            }
            Element formatEl = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "format");
            formatEl.appendChild(doc.createTextNode(format));
            context.appendChild(formatEl);
            Element arity = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "arity");
            if (separator != null) {
                Element separatorEl = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "separated-files");
                separatorEl.appendChild(doc.createTextNode(separator));
                arity.appendChild(separatorEl);
            } else {
                arity.appendChild(doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "one-file-only"));
            }
            context.appendChild(arity);
            action.appendChild(context);
        } else {
            Element contextMenu;
            Element view = XMLUtil.findElement((Element)data, (String)"view", (String)"http://www.netbeans.org/ns/freeform-project/2");
            if (view != null && (contextMenu = XMLUtil.findElement((Element)view, (String)"context-menu", (String)"http://www.netbeans.org/ns/freeform-project/2")) != null) {
                Element ideAction = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "ide-action");
                ideAction.setAttribute("name", command);
                contextMenu.appendChild(ideAction);
            }
        }
        ideActions.appendChild(action);
        Util.putPrimaryConfigurationData((AntProjectHelper)this.helper, (Element)data);
        ProjectManager.getDefault().saveProject(this.project);
    }

    private void jumpToBuildScript(String scriptPath, String target) {
        this.jumpToFile(scriptPath, target, "target", "name");
    }

    private void jumpToBinding(String command) {
        this.jumpToFile("nbproject/project.xml", command, "action", "name");
    }

    private void jumpToFile(String path, String match, String elementLocalName, String elementAttributeName) {
        DataObject fileDO;
        int line;
        FileObject file = this.helper.getProjectDirectory().getFileObject(path);
        if (file == null) {
            return;
        }
        try {
            line = JavaActions.findLine(file, match, elementLocalName, elementAttributeName);
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            return;
        }
        if (line == -1) {
            line = 0;
        }
        try {
            fileDO = DataObject.find((FileObject)file);
        }
        catch (DataObjectNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        LineCookie lines = (LineCookie)fileDO.getCookie(LineCookie.class);
        if (lines != null) {
            try {
                lines.getLineSet().getCurrent(line).show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
            }
            catch (IndexOutOfBoundsException e) {
                ErrorManager.getDefault().getInstance(JavaActions.class.getName()).log(16, e + " [file=" + file + " match=" + match + " line=" + line + "]");
                lines.getLineSet().getCurrent(0).show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
            }
        }
    }

    static final int findLine(FileObject file, final String match, final String elementLocalName, final String elementAttributeName) throws IOException, SAXException, ParserConfigurationException {
        InputSource in = new InputSource(file.toURL().toString());
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser parser = factory.newSAXParser();
        final int[] line = new int[]{-1};
        class Handler
        extends DefaultHandler {
            private Locator locator;

            Handler() {
            }

            @Override
            public void setDocumentLocator(Locator l) {
                this.locator = l;
            }

            @Override
            public void startElement(String uri, String localname, String qname, Attributes attr) throws SAXException {
                if (line[0] == -1 && localname.equals(elementLocalName) && match.equals(attr.getValue(elementAttributeName))) {
                    line[0] = this.locator.getLineNumber() - 1;
                }
            }
        }
        parser.parse(in, (DefaultHandler)new Handler());
        return line[0];
    }

    Element findExistingBuildTarget(String command) throws IOException, SAXException {
        String targetName;
        String[] binding = this.findCommandBinding(command);
        if (binding == null) {
            return null;
        }
        String scriptName = binding[0];
        assert (scriptName != null);
        if (binding.length == 1) {
            targetName = null;
        } else if (binding.length == 2) {
            targetName = binding[1];
        } else {
            return null;
        }
        String scriptPath = this.evaluator.evaluate(scriptName);
        if (scriptPath == null) {
            return null;
        }
        File scriptFile = this.helper.resolveFile(scriptPath);
        String scriptURI = Utilities.toURI((File)scriptFile).toString();
        Document doc = XMLUtil.parse((InputSource)new InputSource(scriptURI), (boolean)false, (boolean)true, null, null);
        if (targetName == null && (targetName = doc.getDocumentElement().getAttribute("default")) == null) {
            return null;
        }
        for (Element target : XMLUtil.findSubElements((Element)doc.getDocumentElement())) {
            if (!target.getLocalName().equals("target") || !targetName.equals(target.getAttribute("name"))) continue;
            return target;
        }
        return null;
    }

    String[] findCommandBinding(String command) {
        Element data = Util.getPrimaryConfigurationData((AntProjectHelper)this.helper);
        Element ideActions = XMLUtil.findElement((Element)data, (String)"ide-actions", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (ideActions == null) {
            return null;
        }
        String scriptName = "build.xml";
        for (Element action : XMLUtil.findSubElements((Element)ideActions)) {
            FileObject nbjdkFO;
            assert (action.getLocalName().equals("action"));
            if (!action.getAttribute("name").equals(command)) continue;
            Element script = XMLUtil.findElement((Element)action, (String)"script", (String)"http://www.netbeans.org/ns/freeform-project/2");
            if (script != null) {
                scriptName = XMLUtil.findText((Node)script);
            }
            ArrayList<String> scriptPlusTargetNames = new ArrayList<String>();
            scriptPlusTargetNames.add(scriptName);
            for (Element target : XMLUtil.findSubElements((Element)action)) {
                if (!target.getLocalName().equals("target")) continue;
                scriptPlusTargetNames.add(XMLUtil.findText((Node)target));
            }
            if (scriptName.equals("nbproject/nbjdk.xml") && scriptPlusTargetNames.size() > 1 && (nbjdkFO = this.helper.getProjectDirectory().getFileObject("nbproject/nbjdk.xml")) != null) {
                try {
                    Document nbjdk = XMLUtil.parse((InputSource)new InputSource(nbjdkFO.toURL().toString()), (boolean)false, (boolean)false, null, null);
                    NodeList nl = nbjdk.getElementsByTagName("target");
                    for (int i = 0; i < nl.getLength(); ++i) {
                        NodeList nl2;
                        if (!((Element)nl.item(i)).getAttribute("name").equals(scriptPlusTargetNames.get(1)) || (nl2 = ((Element)nl.item(i)).getElementsByTagName("ant")).getLength() != 1) continue;
                        String antfile = ((Element)nl2.item(0)).getAttribute("antfile");
                        if (antfile.length() == 0) {
                            antfile = "build.xml";
                        }
                        scriptPlusTargetNames.set(0, antfile);
                        break;
                    }
                }
                catch (Exception x) {
                    Exceptions.printStackTrace((Throwable)x);
                }
            }
            return scriptPlusTargetNames.toArray(new String[0]);
        }
        return null;
    }

    Element targetUsesTaskExactlyOnce(Element target, String taskName) {
        Element foundTask = null;
        for (Element task : XMLUtil.findSubElements((Element)target)) {
            if (!task.getLocalName().equals(taskName)) continue;
            if (foundTask != null) {
                return null;
            }
            foundTask = task;
        }
        return foundTask;
    }

    private void handleRunSingle(Lookup context) throws IOException, SAXException {
        if (!this.alert(NbBundle.getMessage(JavaActions.class, (String)"ACTION_run.single"), FILE_SCRIPT_PATH)) {
            return;
        }
        Document doc = this.readCustomScript(FILE_SCRIPT_PATH);
        AntLocation root = this.handleInitials(doc, context);
        assert (root != null) : context;
        String propertyName = "run.class";
        String targetName = "run-selected-file-in-" + root.physical.getNameExt();
        Element target = this.createRunSingleTargetElem(doc, targetName, propertyName, root);
        doc.getDocumentElement().appendChild(target);
        this.writeCustomScript(doc, FILE_SCRIPT_PATH);
        this.addBinding("run.single", FILE_SCRIPT_PATH, targetName, propertyName, root.virtual, JAVA_FILE_PATTERN, "java-name", null);
        this.jumpToBinding("run.single");
        this.jumpToBuildScript(FILE_SCRIPT_PATH, targetName);
    }

    private void handleDebugSingle(Lookup context) throws IOException, SAXException {
        if (!this.alert(NbBundle.getMessage(JavaActions.class, (String)"ACTION_debug.single"), FILE_SCRIPT_PATH)) {
            return;
        }
        Document doc = this.readCustomScript(FILE_SCRIPT_PATH);
        AntLocation root = this.handleInitials(doc, context);
        assert (root != null) : context;
        String propertyName = "debug.class";
        String targetName = "debug-selected-file-in-" + root.physical.getNameExt();
        Element targetElem = this.createDebugSingleTargetElem(doc, targetName, propertyName, root);
        doc.getDocumentElement().appendChild(targetElem);
        this.writeCustomScript(doc, FILE_SCRIPT_PATH);
        this.addBinding("debug.single", FILE_SCRIPT_PATH, targetName, propertyName, root.virtual, JAVA_FILE_PATTERN, "java-name", null);
        this.jumpToBinding("debug.single");
        this.jumpToBuildScript(FILE_SCRIPT_PATH, targetName);
    }

    private void handleProfileSingle(Lookup context) throws IOException, SAXException {
        if (!this.alert(NbBundle.getMessage(JavaActions.class, (String)"ACTION_profile.single"), FILE_SCRIPT_PATH)) {
            return;
        }
        Document doc = this.readCustomScript(FILE_SCRIPT_PATH);
        AntLocation root = this.handleInitials(doc, context);
        assert (root != null) : context;
        String propertyName = "profile.class";
        String targetName = "profile-selected-file-in-" + root.physical.getNameExt();
        Element targetElem = this.createProfileSingleTargetElem(doc, targetName, propertyName, root);
        doc.getDocumentElement().appendChild(targetElem);
        this.writeCustomScript(doc, FILE_SCRIPT_PATH);
        this.addBinding("profile.single", FILE_SCRIPT_PATH, targetName, propertyName, root.virtual, JAVA_FILE_PATTERN, "java-name", null);
        this.jumpToBinding("profile.single");
        this.jumpToBuildScript(FILE_SCRIPT_PATH, targetName);
    }

    Element createRunSingleTargetElem(Document doc, String tgName, String propName, AntLocation root) throws IOException, SAXException {
        Element targetElem = doc.createElement("target");
        this.addJdkInitDeps(targetElem);
        targetElem.setAttribute("name", tgName);
        Element failElem = doc.createElement("fail");
        failElem.setAttribute("unless", propName);
        failElem.appendChild(doc.createTextNode(NbBundle.getMessage(JavaActions.class, (String)"COMMENT_must_set_property", (Object)propName)));
        targetElem.appendChild(failElem);
        String[] depends = this.getRunDepends();
        if (depends != null) {
            targetElem.appendChild(this.createAntElem(doc, depends[0], depends[1]));
        }
        Element javaElem = doc.createElement("java");
        javaElem.setAttribute("classname", "${" + propName + "}");
        javaElem.setAttribute("fork", "true");
        javaElem.setAttribute("failonerror", "true");
        Element cpElem = this.getPathFromCU(doc, root.virtual, "classpath");
        if (cpElem.getChildNodes().getLength() == 0) {
            cpElem.appendChild(doc.createComment(" " + NbBundle.getMessage(JavaActions.class, (String)"COMMENT_set_runtime_cp") + " "));
        }
        javaElem.appendChild(cpElem);
        targetElem.appendChild(javaElem);
        return targetElem;
    }

    Element createDebugSingleTargetElem(Document doc, String tgName, String propName, AntLocation root) throws IOException, SAXException {
        Element targetElem = doc.createElement("target");
        this.addJdkInitDeps(targetElem);
        targetElem.setAttribute("name", tgName);
        Element failElem = doc.createElement("fail");
        failElem.setAttribute("unless", propName);
        failElem.appendChild(doc.createTextNode(NbBundle.getMessage(JavaActions.class, (String)"COMMENT_must_set_property", (Object)propName)));
        targetElem.appendChild(failElem);
        String[] depends = this.getRunDepends();
        if (depends != null) {
            targetElem.appendChild(this.createAntElem(doc, depends[0], depends[1]));
        }
        Element pElem = this.getPathFromCU(doc, root.virtual, "path");
        pElem.setAttribute("id", "cp");
        if (pElem.getChildNodes().getLength() == 0) {
            pElem.appendChild(doc.createComment(" " + NbBundle.getMessage(JavaActions.class, (String)"COMMENT_set_runtime_cp") + " "));
        }
        targetElem.appendChild(pElem);
        Element nbjpdastartElem = this.createNbjpdastart(doc);
        Element cpElem = doc.createElement("classpath");
        cpElem.setAttribute("refid", "cp");
        nbjpdastartElem.appendChild(cpElem);
        targetElem.appendChild(nbjpdastartElem);
        Element javaElem = doc.createElement("java");
        javaElem.setAttribute("classname", "${" + propName + "}");
        cpElem = doc.createElement("classpath");
        cpElem.setAttribute("refid", "cp");
        javaElem.appendChild(cpElem);
        this.addDebugVMArgs(javaElem, doc);
        targetElem.appendChild(javaElem);
        return targetElem;
    }

    Element createProfileSingleTargetElem(Document doc, String tgName, String propName, AntLocation root) throws IOException, SAXException {
        Element targetElem = doc.createElement("target");
        this.addJdkInitDeps(targetElem);
        targetElem.setAttribute("name", tgName);
        targetElem.setAttribute("if", "profiler.configured");
        targetElem.setAttribute("depends", "-profile-check");
        Element failElem = doc.createElement("fail");
        failElem.setAttribute("unless", propName);
        failElem.appendChild(doc.createTextNode(NbBundle.getMessage(JavaActions.class, (String)"COMMENT_must_set_property", (Object)propName)));
        targetElem.appendChild(failElem);
        String[] depends = this.getRunDepends();
        if (depends != null) {
            targetElem.appendChild(this.createAntElem(doc, depends[0], depends[1]));
        }
        Element pElem = this.getPathFromCU(doc, root.virtual, "path");
        pElem.setAttribute("id", "cp");
        if (pElem.getChildNodes().getLength() == 0) {
            pElem.appendChild(doc.createComment(" " + NbBundle.getMessage(JavaActions.class, (String)"COMMENT_set_runtime_cp") + " "));
        }
        targetElem.appendChild(pElem);
        Element cpElem = doc.createElement("classpath");
        cpElem.setAttribute("refid", "cp");
        Element javaElem = doc.createElement("java");
        javaElem.setAttribute("classname", "${" + propName + "}");
        cpElem = doc.createElement("classpath");
        cpElem.setAttribute("refid", "cp");
        javaElem.appendChild(cpElem);
        this.addProfileInit(doc, doc.getDocumentElement());
        this.addProfileVMArgs(javaElem, doc);
        targetElem.appendChild(javaElem);
        return targetElem;
    }

    private AntLocation handleInitials(Document doc, Lookup context) {
        this.ensurePropertiesCopied(doc.getDocumentElement());
        Comment comm = doc.createComment(" " + NbBundle.getMessage(JavaActions.class, (String)"COMMENT_edit_target") + " ");
        doc.getDocumentElement().appendChild(comm);
        comm = doc.createComment(" " + NbBundle.getMessage(JavaActions.class, (String)"COMMENT_more_info_run.single") + " ");
        doc.getDocumentElement().appendChild(comm);
        return this.findPackageRoot(context);
    }

    String[] getRunDepends() throws IOException, SAXException {
        String[] depends = null;
        Element targetElem = this.findExistingBuildTarget("run");
        if (targetElem == null) {
            return null;
        }
        String[] bindings = this.findCommandBinding("run");
        String dep = targetElem.getAttribute("depends");
        if (bindings != null && bindings.length <= 2 && !"".equals(dep)) {
            depends = new String[]{bindings[0], dep};
        }
        return depends;
    }

    Element getPathFromCU(Document doc, String srcRoot, String type) {
        String cp = this.findCUClasspath(srcRoot, "execute");
        Element pElem = null;
        if (cp != null) {
            pElem = this.createPathLikeElem(doc, type, null, new String[]{cp}, null, null, null);
        } else {
            String[] stringArray;
            cp = this.findCUClasspath(srcRoot, "compile");
            if (cp == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = cp;
            }
            String[] paths = stringArray;
            String[] outputs = this.findCUOutputs(srcRoot);
            pElem = this.createPathLikeElem(doc, type, null, paths, outputs, null, null);
        }
        return pElem;
    }

    Element createPathLikeElem(Document doc, String type, String id, String[] paths, String[] locations, String refid, String comm) {
        Element pathelElem;
        Element pElem = doc.createElement(type);
        if (id != null) {
            pElem.setAttribute("id", id);
        }
        if (refid != null) {
            pElem.setAttribute("refid", refid);
        }
        if (comm != null) {
            pElem.appendChild(doc.createComment(comm));
        }
        if (paths != null && paths.length > 0) {
            for (int i = 0; i < paths.length; ++i) {
                pathelElem = doc.createElement("pathelement");
                pathelElem.setAttribute("path", paths[i]);
                pElem.appendChild(pathelElem);
            }
        }
        if (locations != null && locations.length > 0) {
            for (int j = 0; j < locations.length; ++j) {
                pathelElem = doc.createElement("pathelement");
                pathelElem.setAttribute("location", locations[j]);
                pElem.appendChild(pathelElem);
            }
        }
        return pElem;
    }

    Element createAntElem(Document doc, String antFile, String deps) {
        assert (antFile != null);
        Element antElem = doc.createElement("ant");
        antElem.setAttribute("antfile", antFile);
        antElem.setAttribute("inheritall", "false");
        StringTokenizer st = new StringTokenizer(deps, ",");
        if (st.countTokens() > 1) {
            while (st.hasMoreTokens()) {
                String dep = st.nextToken();
                Element tgElem = doc.createElement("target");
                tgElem.setAttribute("name", dep.trim());
                antElem.appendChild(tgElem);
            }
        } else {
            antElem.setAttribute("target", deps);
        }
        return antElem;
    }

    private boolean isSingleJavaFileSelected(Lookup context) {
        Collection selectedDO = context.lookupAll(DataObject.class);
        return selectedDO.size() == 1 && ((DataObject)selectedDO.iterator().next()).getPrimaryFile().hasExt("java");
    }

    private void addJdkInitDeps(Element target) {
        if (this.helper.getProjectDirectory().getFileObject("nbproject/jdk.xml") != null) {
            String deps = target.getAttribute("depends");
            target.setAttribute("depends", (String)(deps.length() == 0 ? "-jdk-init" : "-jdk-init," + deps));
        }
    }

    static final class AntLocation {
        public final String virtual;
        public final FileObject physical;

        public AntLocation(String virtual, FileObject physical) {
            this.virtual = virtual;
            this.physical = physical;
        }

        public String toString() {
            return "AntLocation[" + this.virtual + "=" + this.physical + "]";
        }
    }
}

