/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jspparser;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jspparser.FastOpenInfoParser;
import org.netbeans.modules.web.jspparser.TldChangeSupport;
import org.netbeans.modules.web.jspparser.WebAppParseProxy;
import org.netbeans.modules.web.jsps.parserapi.JspParserAPI;
import org.netbeans.modules.web.jsps.parserapi.TldChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class JspParserImpl
implements JspParserAPI {
    final Map<WebModule, WebAppParseProxy> parseSupports = new WeakHashMap<WebModule, WebAppParseProxy>();
    private final TldChangeSupport tldChangeSupport = new TldChangeSupport(this);
    private static final Logger LOGGER = Logger.getLogger(JspParserImpl.class.getName());
    private static Method webAppParserImplFactoryMethod;
    private static Method webAppParserJakartaImplFactoryMethod;
    private static final JspParserAPI.JspOpenInfo DEFAULT_OPENINFO;
    private static URL[] urls;
    private static URL[] urlsJakarta;
    private static final String[] JAR_FILE_NAMES;
    private static final String[] JAR_FILE_NAMES_JAKARTA;

    private static void initURLs() throws MalformedURLException, IOException {
        if (urls == null || urlsJakarta == null) {
            urls = JspParserImpl.buildUrlsFromRelativePaths(JAR_FILE_NAMES);
            urlsJakarta = JspParserImpl.buildUrlsFromRelativePaths(JAR_FILE_NAMES_JAKARTA);
        }
    }

    private static URL[] buildUrlsFromRelativePaths(String[] jarFileNames) throws IOException, MalformedURLException {
        File[] files = new File[jarFileNames.length];
        ArrayList<String> missing = new ArrayList<String>();
        for (int i = 0; i < jarFileNames.length; ++i) {
            files[i] = InstalledFileLocator.getDefault().locate(jarFileNames[i], null, false);
            if (files[i] != null) continue;
            missing.add(jarFileNames[i]);
        }
        if (!missing.isEmpty()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Cannot initialize JSP parser, following JAR files couldn't be localted: ");
            for (String fname : missing) {
                msg.append(fname);
                msg.append(',');
            }
            msg.setCharAt(msg.length() - 1, '.');
            throw new IOException(msg.toString());
        }
        URL[] urls2 = new URL[files.length];
        for (int i = 0; i < files.length; ++i) {
            urls2[i] = Utilities.toURI((File)files[i]).toURL();
        }
        return urls2;
    }

    public static void setParserJARs(URL[] urls, URL[] urlsJakarta) {
        JspParserImpl.urls = urls;
        JspParserImpl.urlsJakarta = urlsJakarta;
    }

    private static void initReflection(boolean jakarta) throws IOException {
        if (!jakarta && webAppParserImplFactoryMethod == null || jakarta && webAppParserJakartaImplFactoryMethod == null) {
            try {
                JspParserImpl.initURLs();
                ExtClassLoader urlCL = new ExtClassLoader(jakarta ? urlsJakarta : urls, JspParserImpl.class.getClassLoader());
                Class<?> cl = urlCL.loadClass("org.netbeans.modules.web.jspparser_ext.WebAppParseSupport");
                if (jakarta) {
                    webAppParserJakartaImplFactoryMethod = cl.getDeclaredMethod("create", JspParserImpl.class, WebModule.class);
                } else {
                    webAppParserImplFactoryMethod = cl.getDeclaredMethod("create", JspParserImpl.class, WebModule.class);
                }
            }
            catch (ClassNotFoundException | NoSuchMethodException | MalformedURLException e) {
                LOGGER.log(Level.INFO, null, e);
            }
        }
    }

    @Override
    public JspParserAPI.JspOpenInfo getJspOpenInfo(FileObject jspFile, WebModule wm, boolean useEditor) {
        WebAppParseProxy pp;
        FileObject wmRoot;
        JspParserAPI.JspOpenInfo jspOI;
        FastOpenInfoParser fastOIP = FastOpenInfoParser.get(wm);
        if (fastOIP != null && (jspOI = fastOIP.getJspOpenInfo(jspFile, useEditor)) != null) {
            return jspOI;
        }
        if (wm != null && (wmRoot = wm.getDocumentBase()) != null && (pp = this.getParseProxy(wm)) != null) {
            return pp.getJspOpenInfo(jspFile, useEditor);
        }
        return DEFAULT_OPENINFO;
    }

    @Override
    public JspParserAPI.ParseResult analyzePage(FileObject jspFile, WebModule wm, int errorReportingMode) {
        if (wm == null) {
            return this.getNoWebModuleResult(jspFile, null);
        }
        FileObject wmRoot = wm.getDocumentBase();
        if (wmRoot == null) {
            return this.getNoWebModuleResult(jspFile, wm);
        }
        WebAppParseProxy pp = this.getParseProxy(wm);
        if (pp == null) {
            return this.getNoWebModuleResult(jspFile, wm);
        }
        return pp.analyzePage(jspFile, errorReportingMode);
    }

    @Override
    public Map<String, String[]> getTaglibMap(WebModule wm) throws IOException {
        FileObject wmRoot = wm.getDocumentBase();
        if (wmRoot == null) {
            throw new IOException();
        }
        WebAppParseProxy pp = this.getParseProxy(wm);
        return pp.getTaglibMap(true);
    }

    private synchronized WebAppParseProxy getParseProxy(WebModule wm) {
        WebAppParseProxy pp = this.parseSupports.get(wm);
        if (pp == null || !pp.isValid(wm)) {
            pp = this.createParseProxy(wm);
            this.parseSupports.put(wm, pp);
        }
        return pp;
    }

    private WebAppParseProxy createParseProxy(WebModule wm) {
        try {
            if (wm.getJ2eeProfile().isAtLeast(Profile.JAKARTA_EE_9_WEB)) {
                JspParserImpl.initReflection(true);
                return (WebAppParseProxy)webAppParserJakartaImplFactoryMethod.invoke(null, this, wm);
            }
            JspParserImpl.initReflection(false);
            return (WebAppParseProxy)webAppParserImplFactoryMethod.invoke(null, this, wm);
        }
        catch (IOException ise) {
            LOGGER.log(Level.WARNING, null, ise);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOGGER.log(Level.INFO, null, e);
        }
        return null;
    }

    @Override
    public URLClassLoader getModuleClassLoader(WebModule wm) {
        WebAppParseProxy pp = this.getParseProxy(wm);
        return pp.getWAClassLoader();
    }

    private JspParserAPI.ParseResult getNoWebModuleResult(FileObject jspFile, WebModule wm) {
        JspParserAPI.ErrorDescriptor error = new JspParserAPI.ErrorDescriptor(null, jspFile, -1, -1, NbBundle.getMessage(JspParserImpl.class, (String)"MSG_webModuleNotFound", (Object)jspFile.getNameExt()), "");
        return new JspParserAPI.ParseResult(new JspParserAPI.ErrorDescriptor[]{error});
    }

    @Override
    public void addTldChangeListener(TldChangeListener listener) {
        this.tldChangeSupport.addTldChangeListener(listener);
    }

    @Override
    public void removeTldChangeListener(TldChangeListener listener) {
        this.tldChangeSupport.removeTldChangeListener(listener);
    }

    public void fireChange(WebModule webModule) {
        this.tldChangeSupport.fireChange(webModule);
    }

    static {
        DEFAULT_OPENINFO = new JspParserAPI.JspOpenInfo(false, "ISO-8859-1");
        JAR_FILE_NAMES = new String[]{"ant/lib/ant.jar", "modules/ext/glassfish-jspparser-5.1.0.jar", "modules/ext/jsp-parser-ext.jar", "modules/ext/jstl-api.jar", "modules/ext/jstl-impl.jar", "modules/ext/servlet4.0-jsp2.3-api.jar", "ant/lib/ant-launcher.jar"};
        JAR_FILE_NAMES_JAKARTA = new String[]{"ant/lib/ant.jar", "modules/ext/glassfish-jspparser-7.0.25.jar", "modules/ext/jsp-parser-ext-jakarta.jar", "modules/ext/jstl-jakarta-api.jar", "modules/ext/jstl-jakarta-impl.jar", "modules/ext/servlet-jsp-api-6.1_3.0.jar", "ant/lib/ant-launcher.jar"};
    }

    private static class ExtClassLoader
    extends URLClassLoader {
        private static final AllPermission ALL_PERM = new AllPermission();

        public ExtClassLoader(URL[] classLoadingURLs, ClassLoader parent) {
            super(classLoadingURLs, parent);
        }

        @Override
        protected PermissionCollection getPermissions(CodeSource codesource) {
            PermissionCollection perms = super.getPermissions(codesource);
            perms.add(ALL_PERM);
            return perms;
        }

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (name.startsWith("org.apache.tools.ant.")) {
                Class<?> clazz = this.findClass(name);
                return clazz;
            }
            if (name.startsWith("org.apache.jasper.")) {
                Class<?> clazz = this.findClass(name);
                return clazz;
            }
            return super.loadClass(name, resolve);
        }
    }
}

