/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.fish.payara.micro.plugin;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.fish.payara.micro.plugin.Constants;
import org.netbeans.modules.fish.payara.micro.plugin.POMManager;
import org.netbeans.modules.fish.payara.micro.plugin.TemplateUtil;
import org.netbeans.modules.fish.payara.micro.plugin.Wizards;
import org.netbeans.modules.fish.payara.micro.project.MicroApplication;
import org.netbeans.modules.fish.payara.micro.project.MicroProjectHook;
import org.netbeans.modules.fish.payara.micro.project.ui.PayaraMicroDescriptor;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.model.pom.POMExtensibilityElement;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public final class MicroPluginWizardDescriptor
implements WizardDescriptor.InstantiatingIterator<WizardDescriptor> {
    private int index;
    private WizardDescriptor descriptor;
    private Project project;
    private List<WizardDescriptor.Panel<WizardDescriptor>> panels;

    public static void updateMicroMavenPlugin(Project project, String payaraMicroVersion, String autoBindHttp, String contextRoot) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("autoBindHttp", autoBindHttp);
        params.put("contextRoot", contextRoot);
        params.put("payaraMicroVersion", payaraMicroVersion);
        try (InputStreamReader sourceReader = new InputStreamReader(TemplateUtil.loadResource("org/netbeans/modules/fish/payara/micro/plugin/resources/pom.xml.ftl"));
             StringReader targetReader = new StringReader(TemplateUtil.expandTemplate(sourceReader, params));){
            POMManager pomManager = new POMManager(targetReader, project);
            pomManager.setExtensionOverrideFilter((source, target) -> {
                if ("option".equalsIgnoreCase(source.getName())) {
                    for (POMExtensibilityElement element : target.getExtensibilityElements()) {
                        if (!"key".equals(element.getQName().getLocalPart())) continue;
                        return source.getChild("key").getValue().equals(element.getElementText());
                    }
                }
                return true;
            });
            pomManager.commit();
            pomManager.reload();
        }
    }

    public void initialize(WizardDescriptor descriptor) {
        this.descriptor = descriptor;
        this.index = 0;
        if (this.project == null) {
            this.project = Templates.getProject((WizardDescriptor)descriptor);
        }
        this.panels = new ArrayList<WizardDescriptor.Panel<WizardDescriptor>>();
        this.panels.add((WizardDescriptor.Panel<WizardDescriptor>)new PayaraMicroDescriptor(Constants.PROJECT_TYPE));
        String[] names = new String[]{NbBundle.getMessage(MicroPluginWizardDescriptor.class, (String)"LBL_PayaraMicroPlugin")};
        descriptor.putProperty("NewFileWizard_Title", (Object)NbBundle.getMessage(MicroPluginWizardDescriptor.class, (String)"Templates/PayaraResources/PayaraMicroMavenPlugin"));
        Wizards.mergeSteps(descriptor, this.panels.toArray(new WizardDescriptor.Panel[0]), names);
    }

    public Set instantiate() throws IOException {
        String payaraMicroVersion = (String)this.descriptor.getProperty("payaraMicroVersion");
        String autoBindHttp = (String)this.descriptor.getProperty("autoBindHttp");
        String contextRoot = (String)this.descriptor.getProperty("contextRoot");
        MicroPluginWizardDescriptor.updateMicroMavenPlugin(this.project, payaraMicroVersion, autoBindHttp, contextRoot);
        MicroApplication.registerInstance(this.project);
        new MicroProjectHook(this.project).projectOpened();
        NbMavenProject.fireMavenProjectReload((Project)this.project);
        return Collections.emptySet();
    }

    public void uninitialize(WizardDescriptor wizard) {
        this.panels = null;
    }

    public WizardDescriptor.Panel current() {
        return this.panels.get(this.index);
    }

    public String name() {
        return NbBundle.getMessage(MicroPluginWizardDescriptor.class, (String)"Templates/PayaraResources/PayaraMicroMavenPlugin");
    }

    public boolean hasNext() {
        return this.index < this.panels.size() - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }
}

