/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.editor;

import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import jdk.jshell.Snippet;
import org.netbeans.api.editor.document.AtomicLockDocument;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.netbeans.modules.java.preprocessorbridge.spi.ImportProcessor;
import org.netbeans.modules.jshell.model.ConsoleContents;
import org.netbeans.modules.jshell.model.ConsoleModel;
import org.netbeans.modules.jshell.model.ConsoleSection;
import org.netbeans.modules.jshell.model.SnippetHandle;
import org.netbeans.modules.jshell.support.ShellSession;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.openide.util.Exceptions;

public class JShellImports
implements ImportProcessor {
    public void addImport(Document doc, String fullyQualifiedClassName) {
        Source src = Source.create((Document)doc);
        final int[] retOffset = new int[1];
        final boolean[] retNewline = new boolean[1];
        try {
            ParserManager.parse(Collections.singleton(src), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    int offset;
                    boolean addNewline;
                    ConsoleContents contents = ConsoleContents.get(resultIterator);
                    ConsoleSection in = contents.getSectionModel().getInputSection();
                    retOffset[0] = -1;
                    if (in == null || contents == null) {
                        return;
                    }
                    List<SnippetHandle> snips = contents.getHandles(in);
                    SnippetHandle lastImport = null;
                    for (SnippetHandle sh : snips) {
                        if (sh.getKind() != Snippet.Kind.IMPORT) continue;
                        lastImport = sh;
                    }
                    if (lastImport == null) {
                        addNewline = false;
                        offset = in.getPartBegin();
                    } else {
                        addNewline = true;
                        offset = in.getSnippetBounds((int)snips.indexOf(lastImport)).end;
                    }
                    retOffset[0] = offset;
                    retNewline[0] = addNewline;
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        ConsoleModel model = ConsoleModel.get(doc);
        ShellSession session = ShellSession.get(doc);
        if (model == null || session == null) {
            return;
        }
        int offset = retOffset[0];
        if (offset == -1) {
            return;
        }
        boolean addNewline = retNewline[0];
        AtomicLockDocument ad = (AtomicLockDocument)LineDocumentUtils.as((Document)doc, AtomicLockDocument.class);
        LineDocument ld = (LineDocument)LineDocumentUtils.as((Document)doc, LineDocument.class);
        ad.runAtomic(() -> {
            int o = offset;
            Reformat rf = Reformat.get((Document)doc);
            try {
                if (addNewline) {
                    doc.insertString(o, "\n", null);
                    ++o;
                }
                doc.insertString(o, "import " + fullyQualifiedClassName + ";\n", null);
                int eo = LineDocumentUtils.getLineEndOffset((LineDocument)ld, (int)o);
                rf.lock();
                rf.reformat(o, eo);
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                rf.unlock();
            }
        });
    }
}

