/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.v8debug.sources;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Phaser;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.lib.v8debug.PropertyBoolean;
import org.netbeans.lib.v8debug.V8Arguments;
import org.netbeans.lib.v8debug.V8Command;
import org.netbeans.lib.v8debug.V8Request;
import org.netbeans.lib.v8debug.V8Response;
import org.netbeans.lib.v8debug.V8Script;
import org.netbeans.lib.v8debug.V8StepAction;
import org.netbeans.lib.v8debug.commands.ChangeLive;
import org.netbeans.lib.v8debug.commands.Continue;
import org.netbeans.modules.javascript.v8debug.ScriptsHandler;
import org.netbeans.modules.javascript.v8debug.V8Debugger;
import org.netbeans.modules.javascript.v8debug.api.DebuggerOptions;
import org.netbeans.modules.javascript.v8debug.frames.CallFrame;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

public final class ChangeLiveSupport {
    private static final Logger LOG = Logger.getLogger(ChangeLiveSupport.class.getName());
    private static final String PREP_REGEX = "^(\\(function.*\\(.*\\).*\\{ ).*";
    private static final Pattern PREP_PATTERN = Pattern.compile("^(\\(function.*\\(.*\\).*\\{ ).*", 40);
    private static final String APP_TEXT = "})();";
    public static final String PROP_CHANGES = "changes";
    private final V8Debugger dbg;
    private final FileChangeListener sourceChangeListener;
    private FileChangeDelivery fileChangeDelivery = new FileChangeDelivery();
    private final File[] sourceChangeRoots;
    private final RequestProcessor rp = new RequestProcessor(ChangeLiveSupport.class);
    private final PropertyChangeSupport pcl = new PropertyChangeSupport(this);
    private volatile boolean haveChanges = false;

    public ChangeLiveSupport(V8Debugger dbg) {
        this.dbg = dbg;
        this.sourceChangeListener = new SourceChangeListener();
        this.sourceChangeRoots = dbg.getScriptsHandler().getLocalRoots();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("new ChangeLiveSupport(), sourceChangeRoots = " + Arrays.toString(this.sourceChangeRoots));
        }
        if (this.sourceChangeRoots.length == 0) {
            FileUtil.addFileChangeListener((FileChangeListener)this.sourceChangeListener);
        } else {
            for (File root : this.sourceChangeRoots) {
                FileUtil.addRecursiveListener((FileChangeListener)this.sourceChangeListener, (File)root);
            }
        }
        dbg.addListener(new V8Debugger.Listener(){

            @Override
            public void notifySuspended(boolean suspended) {
            }

            @Override
            public void notifyCurrentFrame(CallFrame cf) {
            }

            @Override
            public void notifyFinished() {
                ChangeLiveSupport.this.destroy();
            }
        });
    }

    public boolean hasChanges() {
        return this.haveChanges;
    }

    private void setHasChanges(boolean haveChanges) {
        if (haveChanges == this.haveChanges) {
            return;
        }
        this.haveChanges = haveChanges;
        this.pcl.firePropertyChange(PROP_CHANGES, !haveChanges, haveChanges);
    }

    public void applyChanges() {
        this.fileChangeDelivery.applyChanges();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcl.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcl.removePropertyChangeListener(l);
    }

    private void applyModifiedFiles(List<FileObject> modifiedFiles) {
        CountDownLatch cdl;
        Continue.Arguments ca;
        V8Request stepInRequest;
        ScriptsHandler sh = this.dbg.getScriptsHandler();
        Collection<V8Script> scripts = sh.getScripts();
        final AtomicBoolean doStepInto = new AtomicBoolean(false);
        final Phaser phaser = new Phaser(1);
        LOG.log(Level.FINE, "applyModifiedFiles({0})", modifiedFiles);
        for (FileObject fo : modifiedFiles) {
            String fileSource;
            int gc;
            String serverPath;
            if (!sh.containsLocalFile(fo)) continue;
            String path = fo.getPath();
            try {
                serverPath = sh.getServerPath(path);
            }
            catch (ScriptsHandler.OutOfScope ex) {
                continue;
            }
            V8Script script = null;
            for (V8Script s : scripts) {
                if (!serverPath.equals(s.getName())) continue;
                script = s;
                break;
            }
            if (script == null) continue;
            String origScriptSource = script.getSource();
            if (origScriptSource == null) {
                origScriptSource = script.getSourceStart();
            }
            String prependedText = null;
            Matcher matcher = PREP_PATTERN.matcher(origScriptSource);
            if (matcher.matches() && (gc = matcher.groupCount()) > 0) {
                prependedText = matcher.group(1);
            }
            try {
                fileSource = fo.asText();
            }
            catch (IOException ioex) {
                continue;
            }
            LOG.fine("Identified changed script " + script.getName());
            if (prependedText != null && !fileSource.startsWith(prependedText)) {
                fileSource = prependedText + fileSource + APP_TEXT;
                LOG.log(Level.FINE, "Header text added: ''{0}'', appended: ''})();''", prependedText);
            }
            ChangeLive.Arguments changeLiveArgs = new ChangeLive.Arguments(script.getId(), fileSource, Boolean.FALSE);
            phaser.register();
            LOG.log(Level.FINE, "Running ChangeLive command for script {0}", script.getName());
            V8Request sendCLRequest = this.dbg.sendCommandRequest(V8Command.Changelive, (V8Arguments)changeLiveArgs, new V8Debugger.CommandResponseCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void notifyResponse(V8Request request, V8Response response) {
                    try {
                        ChangeLive.ResponseBody clrb;
                        if (response != null && (clrb = (ChangeLive.ResponseBody)response.getBody()) != null) {
                            ChangeLive.ChangeLog changeLog = clrb.getChangeLog();
                            if (changeLog != null) {
                                ChangeLiveSupport.this.updateBreakpoints(changeLog.getBreakpointsUpdate());
                            }
                            PropertyBoolean doStepIn = clrb.getStepInRecommended();
                            ChangeLive.Result result = clrb.getResult();
                            if (result != null && !doStepIn.hasValue()) {
                                doStepIn = result.getStackUpdateNeedsStepIn();
                            }
                            if (doStepIn.getValue()) {
                                doStepInto.set(true);
                            }
                        }
                    }
                    finally {
                        LOG.fine("A ChangeLive command finished.");
                        phaser.arriveAndDeregister();
                    }
                }
            });
            if (sendCLRequest != null) continue;
            phaser.arriveAndDeregister();
        }
        phaser.arriveAndAwaitAdvance();
        boolean doStepIn = doStepInto.get();
        doStepIn = doStepIn && this.dbg.isSuspended();
        LOG.log(Level.FINE, "ALl ChangeLive commands processed. Will step into = {0}", doStepIn);
        if (doStepIn && (stepInRequest = this.dbg.sendCommandRequest(V8Command.Continue, (V8Arguments)(ca = new Continue.Arguments(V8StepAction.in)), new V8Debugger.CommandResponseCallback(){
            final /* synthetic */ CountDownLatch val$cdl;
            {
                this.val$cdl = countDownLatch;
            }

            @Override
            public void notifyResponse(V8Request request, V8Response response) {
                if (response != null) {
                    ChangeLiveSupport.this.dbg.addListener(new V8Debugger.Listener(){

                        @Override
                        public void notifySuspended(boolean suspended) {
                            if (suspended) {
                                val$cdl.countDown();
                                ChangeLiveSupport.this.dbg.removeListener(this);
                            }
                        }

                        @Override
                        public void notifyCurrentFrame(CallFrame cf) {
                        }

                        @Override
                        public void notifyFinished() {
                            val$cdl.countDown();
                            ChangeLiveSupport.this.dbg.removeListener(this);
                        }
                    });
                } else {
                    this.val$cdl.countDown();
                }
            }
        })) != null) {
            try {
                cdl.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void updateBreakpoints(ChangeLive.ChangeLog.BreakpointUpdate[] breakpointsUpdate) {
        block4: for (ChangeLive.ChangeLog.BreakpointUpdate bu : breakpointsUpdate) {
            long bpId = bu.getId();
            ChangeLive.ChangeLog.BreakpointUpdate.Type type = bu.getType();
            LOG.fine("updateBreakpoint id = " + bpId + ", type = " + type);
            switch (type) {
                case CopiedToOld: {
                    continue block4;
                }
                case PositionChanged: {
                    ChangeLive.ChangeLog.BreakpointUpdate.Position oldPos = bu.getOldPositions();
                    ChangeLive.ChangeLog.BreakpointUpdate.Position newPos = bu.getNewPositions();
                    this.dbg.getBreakpointsHandler().positionChanged(bpId, newPos.getLine(), newPos.getColumn());
                }
            }
        }
    }

    private void destroy() {
        if (this.sourceChangeRoots.length == 0) {
            FileUtil.removeFileChangeListener((FileChangeListener)this.sourceChangeListener);
        } else {
            for (File root : this.sourceChangeRoots) {
                FileUtil.removeRecursiveListener((FileChangeListener)this.sourceChangeListener, (File)root);
            }
        }
    }

    private final class FileChangeDelivery
    implements Runnable {
        private final List<FileObject> changedFiles = new LinkedList<FileObject>();

        private FileChangeDelivery() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add(FileObject file) {
            List<FileObject> list = this.changedFiles;
            synchronized (list) {
                this.changedFiles.add(file);
            }
            ChangeLiveSupport.this.setHasChanges(true);
        }

        @Override
        public void run() {
            if (DebuggerOptions.getInstance().isLiveEdit()) {
                this.applyChanges();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void applyChanges() {
            ArrayList<FileObject> modifiedFiles;
            List<FileObject> list = this.changedFiles;
            synchronized (list) {
                modifiedFiles = new ArrayList<FileObject>(this.changedFiles);
                this.changedFiles.clear();
            }
            ChangeLiveSupport.this.setHasChanges(false);
            ChangeLiveSupport.this.rp.post(new Runnable(){

                @Override
                public void run() {
                    ChangeLiveSupport.this.applyModifiedFiles(modifiedFiles);
                }
            });
        }
    }

    private final class SourceChangeListener
    implements FileChangeListener {
        private SourceChangeListener() {
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
            ChangeLiveSupport.this.fileChangeDelivery.add(fe.getFile());
            fe.runWhenDeliveryOver((Runnable)ChangeLiveSupport.this.fileChangeDelivery);
        }

        public void fileDeleted(FileEvent fe) {
        }

        public void fileRenamed(FileRenameEvent fe) {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }
}

