/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.ApplyWorkspaceEditResponse;
import org.eclipse.lsp4j.ConfigurationParams;
import org.eclipse.lsp4j.LogTraceParams;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.ProgressParams;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.RegistrationParams;
import org.eclipse.lsp4j.ShowDocumentParams;
import org.eclipse.lsp4j.ShowDocumentResult;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.eclipse.lsp4j.UnregistrationParams;
import org.eclipse.lsp4j.WorkDoneProgressCreateParams;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.explorer.api.NodeChangedParams;
import org.netbeans.modules.java.lsp.server.input.QuickPickItem;
import org.netbeans.modules.java.lsp.server.input.ShowInputBoxParams;
import org.netbeans.modules.java.lsp.server.input.ShowMutliStepInputParams;
import org.netbeans.modules.java.lsp.server.input.ShowQuickPickParams;
import org.netbeans.modules.java.lsp.server.protocol.ClientConfigurationManager;
import org.netbeans.modules.java.lsp.server.protocol.DecorationRenderOptions;
import org.netbeans.modules.java.lsp.server.protocol.HtmlPageParams;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeClientCapabilities;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.protocol.OutputMessage;
import org.netbeans.modules.java.lsp.server.protocol.SaveDocumentRequestParams;
import org.netbeans.modules.java.lsp.server.protocol.SetTextEditorDecorationParams;
import org.netbeans.modules.java.lsp.server.protocol.ShowStatusMessageParams;
import org.netbeans.modules.java.lsp.server.protocol.TestProgressParams;
import org.netbeans.modules.java.lsp.server.protocol.UpdateConfigParams;

class NbCodeClientWrapper
implements NbCodeLanguageClient {
    private final NbCodeLanguageClient remote;
    private volatile NbCodeClientCapabilities clientCaps;
    private final ClientConfigurationManager confManager;

    public NbCodeClientWrapper(NbCodeLanguageClient remote) {
        this.remote = remote;
        this.clientCaps = new NbCodeClientCapabilities();
        this.confManager = new ClientConfigurationManager(this);
    }

    public void setClientCaps(NbCodeClientCapabilities clientCaps) {
        if (clientCaps != null) {
            this.clientCaps = clientCaps;
        }
    }

    @Override
    public NbCodeClientCapabilities getNbCodeCapabilities() {
        return this.clientCaps;
    }

    @Override
    public void showStatusBarMessage(ShowStatusMessageParams params) {
        this.remote.showStatusBarMessage(params);
    }

    @Override
    public CompletableFuture<String> showHtmlPage(HtmlPageParams params) {
        return this.remote.showHtmlPage(params);
    }

    @Override
    public CompletableFuture<String> execInHtmlPage(HtmlPageParams params) {
        return this.remote.execInHtmlPage(params);
    }

    @Override
    public CompletableFuture<List<QuickPickItem>> showQuickPick(ShowQuickPickParams params) {
        ShowQuickPickParams copy = new ShowQuickPickParams(params.getTitle(), params.getPlaceHolder(), params.getCanPickMany(), params.getItems().stream().map(i -> new QuickPickItem(i.getLabel(), Utils.html2plain(i.getDescription(), true), Utils.html2plain(i.getDetail(), true), i.isPicked(), i.getUserData())).collect(Collectors.toList()));
        return this.remote.showQuickPick(copy);
    }

    @Override
    public CompletableFuture<String> showInputBox(ShowInputBoxParams params) {
        return this.remote.showInputBox(params);
    }

    @Override
    public CompletableFuture<Map<String, Either<List<QuickPickItem>, String>>> showMultiStepInput(ShowMutliStepInputParams params) {
        return this.remote.showMultiStepInput(params);
    }

    @Override
    public void notifyTestProgress(TestProgressParams params) {
        this.remote.notifyTestProgress(params);
    }

    public CompletableFuture<ApplyWorkspaceEditResponse> applyEdit(ApplyWorkspaceEditParams params) {
        return this.remote.applyEdit(params);
    }

    public CompletableFuture<Void> registerCapability(RegistrationParams params) {
        return this.remote.registerCapability(params);
    }

    public CompletableFuture<Void> unregisterCapability(UnregistrationParams params) {
        return this.remote.unregisterCapability(params);
    }

    public void telemetryEvent(Object object) {
        this.remote.telemetryEvent(object);
    }

    public void publishDiagnostics(PublishDiagnosticsParams diagnostics) {
        this.remote.publishDiagnostics(diagnostics);
    }

    public void showMessage(MessageParams messageParams) {
        this.remote.showMessage(messageParams);
    }

    public CompletableFuture<MessageActionItem> showMessageRequest(ShowMessageRequestParams requestParams) {
        return this.remote.showMessageRequest(requestParams);
    }

    public CompletableFuture<ShowDocumentResult> showDocument(ShowDocumentParams params) {
        return this.remote.showDocument(params);
    }

    public void logMessage(MessageParams message) {
        this.remote.logMessage(message);
    }

    public CompletableFuture<List<WorkspaceFolder>> workspaceFolders() {
        return this.remote.workspaceFolders();
    }

    public CompletableFuture<List<Object>> configuration(ConfigurationParams configurationParams) {
        return this.remote.configuration(configurationParams);
    }

    public CompletableFuture<Void> createProgress(WorkDoneProgressCreateParams params) {
        return this.remote.createProgress(params);
    }

    public void notifyProgress(ProgressParams params) {
        this.remote.notifyProgress(params);
    }

    @Override
    public CompletableFuture<String> createTextEditorDecoration(DecorationRenderOptions params) {
        return this.remote.createTextEditorDecoration(params);
    }

    @Override
    public void setTextEditorDecoration(SetTextEditorDecorationParams params) {
        this.remote.setTextEditorDecoration(params);
    }

    @Override
    public void disposeTextEditorDecoration(String params) {
        this.remote.disposeTextEditorDecoration(params);
    }

    public void logTrace(LogTraceParams params) {
        this.remote.logTrace(params);
    }

    public CompletableFuture<Void> refreshSemanticTokens() {
        return this.remote.refreshSemanticTokens();
    }

    public CompletableFuture<Void> refreshCodeLenses() {
        return this.remote.refreshCodeLenses();
    }

    @Override
    public void notifyNodeChange(NodeChangedParams params) {
        this.remote.notifyNodeChange(params);
    }

    @Override
    public CompletableFuture<Void> configurationUpdate(UpdateConfigParams params) {
        return this.remote.configurationUpdate(params);
    }

    @Override
    public CompletableFuture<Boolean> requestDocumentSave(SaveDocumentRequestParams documentUris) {
        return this.remote.requestDocumentSave(documentUris);
    }

    @Override
    public CompletableFuture<Void> writeOutput(OutputMessage lm) {
        return this.remote.writeOutput(lm);
    }

    @Override
    public CompletableFuture<Void> showOutput(String outputName) {
        return this.remote.showOutput(outputName);
    }

    @Override
    public CompletableFuture<Void> closeOutput(String outputName) {
        return this.remote.closeOutput(outputName);
    }

    @Override
    public CompletableFuture<Void> resetOutput(String outputName) {
        return this.remote.resetOutput(outputName);
    }

    @Override
    public ClientConfigurationManager getClientConfigurationManager() {
        return this.confManager;
    }
}

