/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Documentation;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Import;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;
import org.netbeans.modules.xml.wsdl.model.Types;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLComponentFactory;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.xsd.WSDLSchema;
import org.netbeans.modules.xml.wsdl.model.impl.ChildComponentUpdateVisitor;
import org.netbeans.modules.xml.wsdl.model.impl.DefinitionsImpl;
import org.netbeans.modules.xml.wsdl.model.impl.ElementFactoryRegistry;
import org.netbeans.modules.xml.wsdl.model.impl.ImportImpl;
import org.netbeans.modules.xml.wsdl.model.impl.SyncReviewVisitor;
import org.netbeans.modules.xml.wsdl.model.impl.WSDLAttribute;
import org.netbeans.modules.xml.wsdl.model.impl.WSDLComponentFactoryImpl;
import org.netbeans.modules.xml.wsdl.model.impl.WSDLQNames;
import org.netbeans.modules.xml.wsdl.model.spi.GenericExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.visitor.FindReferencedVisitor;
import org.netbeans.modules.xml.xam.ComponentUpdater;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.netbeans.modules.xml.xam.dom.ChangeInfo;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.netbeans.modules.xml.xam.dom.SyncUnit;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSDLModelImpl
extends WSDLModel {
    private Definitions definitions;
    private WSDLComponentFactory wcf = new WSDLComponentFactoryImpl(this);

    public WSDLModelImpl(ModelSource source) {
        super(source);
    }

    public WSDLComponent createRootComponent(Element root) {
        QName q;
        DefinitionsImpl newDefinitions = null;
        QName qName = q = root == null ? null : AbstractDocumentComponent.getQName((Node)root);
        if (root == null || !WSDLQNames.DEFINITIONS.getQName().equals(q)) {
            return null;
        }
        newDefinitions = new DefinitionsImpl(this, root);
        this.setDefinitions(newDefinitions);
        return this.getDefinitions();
    }

    public WSDLComponent getRootComponent() {
        return this.definitions;
    }

    public WSDLComponent createComponent(WSDLComponent parent, Element element) {
        return (WSDLComponent)this.getFactory().create(element, parent);
    }

    protected ComponentUpdater<WSDLComponent> getComponentUpdater() {
        return new ChildComponentUpdateVisitor<WSDLComponent>();
    }

    @Override
    public WSDLComponentFactory getFactory() {
        return this.wcf;
    }

    public void setDefinitions(Definitions def) {
        assert (def instanceof DefinitionsImpl);
        this.definitions = (Definitions)DefinitionsImpl.class.cast(def);
    }

    @Override
    public Definitions getDefinitions() {
        return this.definitions;
    }

    ElementFactoryRegistry getElementRegistry() {
        return ElementFactoryRegistry.getDefault();
    }

    public List<WSDLModel> getImportedWSDLModels() {
        ArrayList<WSDLModel> ret = new ArrayList<WSDLModel>();
        Collection<Import> imports = this.getDefinitions().getImports();
        for (Import i : imports) {
            try {
                WSDLModel m = i.getImportedWSDLModel();
                if (m == null) continue;
                ret.add(m);
            }
            catch (Exception e) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.FINE, "getImportedWSDLModels", e);
            }
        }
        return ret;
    }

    public List<SchemaModel> getImportedSchemaModels() {
        ArrayList<SchemaModel> ret = new ArrayList<SchemaModel>();
        Collection<Import> imports = this.getDefinitions().getImports();
        for (Import i : imports) {
            try {
                SchemaModel m = ((ImportImpl)i).resolveToSchemaModel();
                if (m == null) continue;
                ret.add(m);
            }
            catch (Exception e) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.FINE, "getImportedSchemaModels", e);
            }
        }
        return ret;
    }

    public List<SchemaModel> getEmbeddedSchemaModels() {
        ArrayList<SchemaModel> ret = new ArrayList<SchemaModel>();
        Types types = this.getDefinitions().getTypes();
        List<Object> embeddedSchemas = Collections.emptyList();
        if (types != null) {
            embeddedSchemas = types.getExtensibilityElements(WSDLSchema.class);
        }
        for (WSDLSchema wschema : embeddedSchemas) {
            ret.add(wschema.getSchemaModel());
        }
        return ret;
    }

    @Override
    public List<WSDLModel> findWSDLModel(String namespace) {
        if (namespace == null) {
            return Collections.emptyList();
        }
        List<WSDLModel> models = this.getImportedWSDLModels();
        models.add(0, this);
        ArrayList<WSDLModel> ret = new ArrayList<WSDLModel>();
        for (WSDLModel m : models) {
            String targetNamespace = m.getDefinitions().getTargetNamespace();
            if (!namespace.equals(targetNamespace)) continue;
            ret.add(m);
        }
        return ret;
    }

    @Override
    public List<Schema> findSchemas(String namespace) {
        ArrayList<Schema> ret = new ArrayList<Schema>();
        for (SchemaModel sm : this.getEmbeddedSchemaModels()) {
            try {
                ret.addAll(sm.findSchemas(namespace));
            }
            catch (Exception ex) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.FINE, "findSchemas", ex);
            }
        }
        SchemaModel sm = this.findSchemaModelFromImports(namespace);
        if (sm != null) {
            ret.add(sm.getSchema());
        }
        return ret;
    }

    private SchemaModel findSchemaModelFromImports(String namespace) {
        if (namespace == null) {
            return null;
        }
        List<SchemaModel> models = this.getImportedSchemaModels();
        for (SchemaModel m : models) {
            String targetNamespace = m.getSchema().getTargetNamespace();
            if (!namespace.equals(targetNamespace)) continue;
            return m;
        }
        return null;
    }

    @Override
    public <T extends ReferenceableWSDLComponent> T findComponentByName(String name, Class<T> type) {
        return (T)((ReferenceableWSDLComponent)type.cast(new FindReferencedVisitor<T>(this.getDefinitions()).find(name, type)));
    }

    @Override
    public <T extends ReferenceableWSDLComponent> T findComponentByName(QName name, Class<T> type) {
        String namespace = name.getNamespaceURI();
        if (namespace == null) {
            return this.findComponentByName(name.getLocalPart(), type);
        }
        for (WSDLModel targetModel : this.findWSDLModel(namespace)) {
            T found = targetModel.findComponentByName(name.getLocalPart(), type);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public Set<QName> getQNames() {
        return this.getElementRegistry().getKnownQNames();
    }

    public Set<String> getElementNames() {
        return this.getElementRegistry().getKnownElementNames();
    }

    public ChangeInfo prepareChangeInfo(List<? extends Node> pathToRoot, List<? extends Node> nsContextPathToRoot) {
        ChangeInfo change = super.prepareChangeInfo(pathToRoot, nsContextPathToRoot);
        DocumentComponent parentComponent = this.findComponent(change.getRootToParentPath());
        if (parentComponent == null) {
            return change;
        }
        if (!(parentComponent.getModel() instanceof WSDLModel)) {
            this.getElementRegistry().addEmbeddedModelQNames((AbstractDocumentModel)parentComponent.getModel());
            change = super.prepareChangeInfo(pathToRoot, nsContextPathToRoot);
        } else if (this.isDomainElement(parentComponent.getPeer()) && !change.isDomainElement() && change.getChangedElement() != null) {
            if (change.getOtherNonDomainElementNodes() == null || change.getOtherNonDomainElementNodes().isEmpty()) {
                change.setDomainElement(true);
                change.setParentComponent(null);
            } else if (!(parentComponent instanceof Documentation)) {
                ArrayList<Element> rootToChanged = new ArrayList<Element>(change.getRootToParentPath());
                rootToChanged.add(change.getChangedElement());
                DocumentComponent changedComponent = this.findComponent(rootToChanged);
                if (changedComponent != null && changedComponent.getClass().isAssignableFrom(GenericExtensibilityElement.class)) {
                    change.markNonDomainChildAsChanged();
                    change.setParentComponent(null);
                }
            }
        } else {
            change.setParentComponent(parentComponent);
        }
        return change;
    }

    public SyncUnit prepareSyncUnit(ChangeInfo changes, SyncUnit unit) {
        if ((unit = super.prepareSyncUnit(changes, unit)) != null) {
            return new SyncReviewVisitor().review(unit);
        }
        return null;
    }

    public AbstractDocumentComponent findComponent(AbstractDocumentComponent current, List<Element> pathFromRoot, int iCurrent) {
        if (current instanceof ExtensibilityElement.EmbeddedModel) {
            ExtensibilityElement.EmbeddedModel emb = (ExtensibilityElement.EmbeddedModel)current;
            AbstractDocumentModel axm = (AbstractDocumentModel)emb.getEmbeddedModel();
            AbstractDocumentComponent embedded = (AbstractDocumentComponent)axm.getRootComponent();
            return axm.findComponent(embedded, pathFromRoot, iCurrent);
        }
        return super.findComponent(current, pathFromRoot, iCurrent);
    }

    public Map<QName, List<QName>> getQNameValuedAttributes() {
        return WSDLAttribute.getQNameValuedAttributes();
    }

    public String toString() {
        FileObject fileObject;
        Lookup lookup;
        ModelSource source = this.getModelSource();
        if (source != null && (lookup = source.getLookup()) != null && (fileObject = (FileObject)lookup.lookup(FileObject.class)) != null) {
            return fileObject.getNameExt();
        }
        return super.toString();
    }
}

