/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.core.startup.layers.BinaryFS;
import org.netbeans.core.startup.layers.LayerCacheManager;
import org.netbeans.core.startup.layers.ParsingLayerCacheManager;
import org.netbeans.core.startup.preferences.RelPaths;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;

final class BinaryCacheManager
extends ParsingLayerCacheManager {
    private final String cacheLocation;
    private static final String[] ATTR_TYPES = new String[]{"bytevalue", "shortvalue", "intvalue", "longvalue", "floatvalue", "doublevalue", "boolvalue", "charvalue", "stringvalue", "urlvalue", "methodvalue", "newvalue", "serialvalue", "bundlevalue"};
    private HashMap<ParsingLayerCacheManager.MemFileOrFolder, Integer> sizes;

    BinaryCacheManager() {
        this("all-layers.dat");
    }

    BinaryCacheManager(String cacheLocation) {
        this.cacheLocation = cacheLocation;
    }

    @Override
    public FileSystem createEmptyFileSystem() throws IOException {
        return FileUtil.createMemoryFileSystem();
    }

    @Override
    public FileSystem load(FileSystem previous, ByteBuffer bb) throws IOException {
        try {
            BinaryFS fs = new BinaryFS(this.cacheLocation(), bb);
            return fs;
        }
        catch (BufferUnderflowException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public String cacheLocation() {
        return this.cacheLocation;
    }

    @Override
    protected boolean openURLs() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void store(FileSystem fs, ParsingLayerCacheManager.MemFolder root, OutputStream os) throws IOException {
        try {
            this.sizes = new HashMap(1000);
            HashMap<String, int[]> strings = new HashMap<String, int[]>();
            int fsSize = this.computeSize(root, strings);
            LayerCacheManager.err.log(Level.FINE, "Writing binary layer cache of length {0} to {1}", new Object[]{fsSize + BinaryFS.MAGIC.length, this.cacheLocation()});
            os.write(BinaryFS.MAGIC);
            BinaryWriter bw = new BinaryWriter(os, root, fsSize, strings);
            this.writeFolder(bw, root, true);
        }
        finally {
            this.sizes = null;
            os.close();
        }
    }

    void writeFolder(BinaryWriter bw, ParsingLayerCacheManager.MemFolder folder) throws IOException {
        this.writeFolder(bw, folder, false);
    }

    void writeFolder(BinaryWriter bw, ParsingLayerCacheManager.MemFolder folder, boolean emptyURLsAllowed) throws IOException {
        this.writeBaseURLs(folder, bw, emptyURLsAllowed);
        if (folder.attrs != null) {
            bw.writeInt(folder.attrs.size());
            for (ParsingLayerCacheManager.MemAttr attr : folder.attrs) {
                this.writeAttribute(bw, attr);
            }
        } else {
            bw.writeInt(0);
        }
        if (folder.children != null) {
            bw.writeInt(folder.children.size());
            int baseOffset = bw.getPosition();
            for (ParsingLayerCacheManager.MemFileOrFolder item : folder.children) {
                baseOffset += this.computeHeaderSize(item, null);
            }
            for (ParsingLayerCacheManager.MemFileOrFolder item : folder.children) {
                bw.writeString(item.name);
                bw.writeByte(item instanceof ParsingLayerCacheManager.MemFile ? (byte)0 : 1);
                bw.writeInt(baseOffset);
                baseOffset += this.computeSize(item, null);
            }
            for (ParsingLayerCacheManager.MemFileOrFolder item : folder.children) {
                if (item instanceof ParsingLayerCacheManager.MemFile) {
                    this.writeFile(bw, (ParsingLayerCacheManager.MemFile)item);
                    continue;
                }
                this.writeFolder(bw, (ParsingLayerCacheManager.MemFolder)item);
            }
        } else {
            bw.writeInt(0);
        }
    }

    private void writeBaseURLs(ParsingLayerCacheManager.MemFileOrFolder folder, BinaryWriter bw, boolean emptyURLsAllowed) throws IOException {
        List<URL> urls = folder.getURLs();
        if (urls.size() > 0) {
            int last = urls.size() - 1;
            for (int i = 0; i < last; ++i) {
                URL u = urls.get(i);
                bw.writeBaseURL(u);
            }
            bw.writeBaseURL(urls.get(last), true);
        } else assert (emptyURLsAllowed);
    }

    private void writeFile(BinaryWriter bw, ParsingLayerCacheManager.MemFile file) throws IOException {
        this.writeBaseURLs(file, bw, false);
        if (file.attrs != null) {
            bw.writeInt(file.attrs.size());
            for (ParsingLayerCacheManager.MemAttr attr : file.attrs) {
                this.writeAttribute(bw, attr);
            }
        } else {
            bw.writeInt(0);
        }
        if (file.ref != null) {
            bw.writeInt(-1);
            bw.writeString(BinaryCacheManager.toRelativeURL(file.ref));
        } else if (file.contents != null) {
            bw.writeInt(file.contents.length);
            bw.writeBytes(file.contents);
        } else {
            bw.writeInt(0);
        }
    }

    private void writeAttribute(BinaryWriter bw, ParsingLayerCacheManager.MemAttr attr) throws IOException {
        bw.writeString(attr.name);
        for (int i = 0; i < ATTR_TYPES.length; ++i) {
            if (!ATTR_TYPES[i].equals(attr.type)) continue;
            bw.writeByte((byte)i);
            if (i == 9) {
                bw.writeString(BinaryCacheManager.toRelativeURL(attr.data));
            } else {
                bw.writeString(attr.data);
            }
            return;
        }
        throw new IOException("Wrong type: " + attr);
    }

    private int computeSize(ParsingLayerCacheManager.MemFileOrFolder mf, Map<String, int[]> text) {
        int size;
        block7: {
            block5: {
                ParsingLayerCacheManager.MemFile file;
                block6: {
                    Integer i = this.sizes.get(mf);
                    if (i != null) {
                        return i;
                    }
                    size = mf.getURLs().size() * 4;
                    size += 4;
                    if (mf.attrs != null) {
                        for (ParsingLayerCacheManager.MemAttr attr : mf.attrs) {
                            size += this.computeSize(attr, text);
                        }
                    }
                    if (!(mf instanceof ParsingLayerCacheManager.MemFile)) break block5;
                    file = (ParsingLayerCacheManager.MemFile)mf;
                    size += 4;
                    if (file.ref == null) break block6;
                    size += BinaryCacheManager.computeSize(BinaryCacheManager.toRelativeURL(file.ref), text);
                    break block7;
                }
                if (file.contents == null) break block7;
                size += file.contents.length;
                break block7;
            }
            ParsingLayerCacheManager.MemFolder folder = (ParsingLayerCacheManager.MemFolder)mf;
            size += 4;
            if (folder.children != null) {
                for (ParsingLayerCacheManager.MemFileOrFolder item : folder.children) {
                    size += this.computeHeaderSize(item, text);
                    size += this.computeSize(item, text);
                }
            }
        }
        this.sizes.put(mf, size);
        return size;
    }

    private int computeHeaderSize(ParsingLayerCacheManager.MemFileOrFolder mof, Map<String, int[]> text) {
        return BinaryCacheManager.computeSize(mof.name, text) + 1 + 4;
    }

    private static int computeSize(String s, Map<String, int[]> text) {
        if (text != null) {
            int[] count = text.get(s);
            if (count == null) {
                count = new int[1];
                text.put(s, count);
            }
            count[0] = count[0] + 1;
        }
        return 4;
    }

    private int computeSize(ParsingLayerCacheManager.MemAttr attr, Map<String, int[]> text) {
        return BinaryCacheManager.computeSize(attr.name, text) + 1 + BinaryCacheManager.computeSize(attr.data, text);
    }

    private static String toRelativeURL(URL u) {
        return BinaryCacheManager.toRelativeURL(u.toExternalForm());
    }

    private static String toRelativeURL(String tmp) {
        String[] relPath;
        if (((String)tmp).startsWith("jar:file:") && (relPath = RelPaths.findRelativePath(((String)tmp).substring(9))) != null) {
            tmp = relPath[0] + "@" + relPath[1];
        }
        return tmp;
    }

    private static final class BinaryWriter {
        private OutputStream os;
        private int position;
        private final Map<String, Object> urls;
        private final Map<String, Integer> strings;

        BinaryWriter(OutputStream os, ParsingLayerCacheManager.MemFolder root, int fsSize, Map<String, int[]> strings) throws IOException {
            this.os = os;
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            this.strings = Collections.unmodifiableMap(map);
            this.urls = this.writeBaseUrls(root, fsSize, strings, map);
            this.position = 0;
        }

        int getPosition() {
            return this.position;
        }

        void writeByte(byte b) throws IOException {
            this.os.write(b);
            ++this.position;
        }

        void writeBytes(byte[] bytes) throws IOException {
            this.os.write(bytes);
            this.position += bytes.length;
        }

        void writeInt(int num) throws IOException {
            byte[] data = new byte[]{(byte)num, (byte)(num >> 8), (byte)(num >> 16), (byte)(num >> 24)};
            this.writeBytes(data);
        }

        void writeString(String str) throws IOException {
            Integer offset = this.strings.get(str);
            assert (offset != null) : "Found " + str;
            this.writeInt(offset);
        }

        void writeBaseURL(URL url) throws IOException {
            this.writeBaseURL(url, false);
        }

        void writeBaseURL(URL url, boolean negative) throws IOException {
            String relUrl = BinaryCacheManager.toRelativeURL(url);
            int[] number = (int[])this.urls.get(relUrl);
            assert (number != null) : "Should not be null, because it was collected: " + url + " map: " + this.urls;
            int index = number[0];
            if (negative) {
                index = -10 - index;
            }
            this.writeInt(index);
        }

        private Map<String, Object> writeBaseUrls(ParsingLayerCacheManager.MemFileOrFolder root, int fsSize, Map<String, int[]> texts, Map<String, Integer> fillIn) throws IOException {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            int[] counter = new int[1];
            this.collectBaseUrls(root, map, counter);
            int size = 0;
            Iterator<Map.Entry<String, Object>> it = map.entrySet().iterator();
            for (int i = 0; i < counter[0]; ++i) {
                Map.Entry<String, Object> entry = it.next();
                String u = entry.getKey();
                assert (((int[])entry.getValue())[0] == i) : i + "th key should be it " + ((int[])entry.getValue())[0];
                size += BinaryCacheManager.computeSize(u, texts);
            }
            ByteArrayOutputStream arr = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(arr);
            for (String txt : this.sort(texts.entrySet())) {
                fillIn.put(txt, dos.size());
                dos.writeUTF(txt);
            }
            dos.flush();
            int textSize = dos.size();
            this.writeInt(BinaryFS.MAGIC.length + 4 + 4 + textSize + 4 + size + fsSize);
            this.writeInt(textSize);
            this.os.write(arr.toByteArray());
            this.writeInt(size);
            it = map.entrySet().iterator();
            for (int i = 0; i < counter[0]; ++i) {
                Map.Entry<String, Object> entry = it.next();
                this.writeString(entry.getKey());
            }
            return map;
        }

        private void collectBaseUrls(ParsingLayerCacheManager.MemFileOrFolder f, Map<String, Object> map, int[] counter) {
            for (URL u : f.getURLs()) {
                String tmp = BinaryCacheManager.toRelativeURL(u);
                int[] exists = (int[])map.get(tmp);
                if (exists != null) continue;
                map.put(tmp, counter.clone());
                counter[0] = counter[0] + 1;
            }
            if (f instanceof ParsingLayerCacheManager.MemFolder && ((ParsingLayerCacheManager.MemFolder)f).children != null) {
                for (ParsingLayerCacheManager.MemFileOrFolder item : ((ParsingLayerCacheManager.MemFolder)f).children) {
                    this.collectBaseUrls(item, map, counter);
                }
            }
        }

        private List<String> sort(Set<Map.Entry<String, int[]>> entrySet) {
            ArrayList<Map.Entry<String, int[]>> lst = new ArrayList<Map.Entry<String, int[]>>(entrySet);
            class C
            implements Comparator<Map.Entry<String, int[]>> {
                C() {
                }

                @Override
                public int compare(Map.Entry<String, int[]> o1, Map.Entry<String, int[]> o2) {
                    return o2.getValue()[0] - o1.getValue()[0];
                }
            }
            lst.sort(new C());
            ArrayList<String> res = new ArrayList<String>();
            for (Map.Entry entry : lst) {
                res.add((String)entry.getKey());
            }
            return res;
        }
    }
}

