/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at.internal;

import java.io.Serializable;
import java.util.Arrays;
import javax.transaction.xa.Xid;

public class XidImpl
implements Xid,
Serializable {
    int formatId;
    byte[] globalTransactionId;
    byte[] branchQual;

    public XidImpl(Xid xid) {
        this.formatId = xid.getFormatId();
        this.globalTransactionId = xid.getGlobalTransactionId();
        this.branchQual = xid.getBranchQualifier();
    }

    public XidImpl(int formatId, byte[] globalTransactionId, byte[] branchQual) {
        this.formatId = formatId;
        this.globalTransactionId = globalTransactionId;
        this.branchQual = branchQual;
    }

    public XidImpl(byte[] globalTransactionId) {
        this(1234, globalTransactionId, new byte[0]);
    }

    public XidImpl(byte[] globalTransactionId, int formatId) {
        this(formatId, globalTransactionId, new byte[0]);
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branchQual;
    }

    public int hashCode() {
        int pos = 0;
        byte[] array = this.globalTransactionId;
        return (short)((array[pos++] & 0xFF) << 8 | array[pos] & 0xFF);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Xid)) {
            return false;
        }
        Xid thatXid = (Xid)obj;
        boolean formatId = this.getFormatId() == thatXid.getFormatId();
        boolean gtrid = Arrays.equals(this.getGlobalTransactionId(), thatXid.getGlobalTransactionId());
        boolean branchqual = Arrays.equals(this.getBranchQualifier(), thatXid.getBranchQualifier());
        return formatId && gtrid && branchqual;
    }
}

