/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server.system;

import java.io.File;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

class Histogram18 {
    private static final String LIVE_OBJECTS_OPTION = "-live";
    private static final String ALL_OBJECTS_OPTION = "-all";
    private static final String VIRTUAL_MACHINE_CLASS = "com.sun.tools.attach.VirtualMachine";
    private static final String HS_VIRTUAL_MACHINE_CLASS = "sun.tools.attach.HotSpotVirtualMachine";
    private static final String VIRTUAL_MACHINE_ATTACH_METHOD = "attach";
    private static final String VIRTUAL_MACHINE_HEAPHISTO_METHOD = "heapHisto";
    private static String selfPid;
    private static Method vmAttach;
    private static Method vmHisto;
    private static Object virtualMachine;

    Histogram18() {
    }

    static InputStream getRawHistogram() {
        try {
            Object ret;
            if (virtualMachine == null) {
                virtualMachine = vmAttach.invoke(null, selfPid);
            }
            if ((ret = vmHisto.invoke(virtualMachine, new Object[]{new Object[]{ALL_OBJECTS_OPTION}})) instanceof InputStream) {
                return (InputStream)ret;
            }
        }
        catch (IllegalAccessException ex) {
            return null;
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
        catch (InvocationTargetException ex) {
            return null;
        }
        return null;
    }

    private static ClassLoader getToolsJar() {
        File home = Histogram18.getJavaHome();
        File toolsJar = new File(home, "lib/tools.jar");
        if (toolsJar.exists() && toolsJar.isFile()) {
            try {
                return new URLClassLoader(new URL[]{toolsJar.toURI().toURL()});
            }
            catch (MalformedURLException ex) {
                return null;
            }
        }
        return null;
    }

    private static File getJavaHome() {
        File jdkHome = new File(System.getProperty("java.home"));
        if ("jre".equals(jdkHome.getName())) {
            jdkHome = jdkHome.getParentFile();
        }
        return jdkHome;
    }

    static boolean initialize() {
        try {
            Class vmClass = Histogram18.loadClass(VIRTUAL_MACHINE_CLASS);
            Class<?> hsVmClass = Class.forName(HS_VIRTUAL_MACHINE_CLASS, true, vmClass.getClassLoader());
            vmAttach = vmClass.getMethod(VIRTUAL_MACHINE_ATTACH_METHOD, String.class);
            vmHisto = hsVmClass.getMethod(VIRTUAL_MACHINE_HEAPHISTO_METHOD, Object[].class);
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
            return false;
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
            return false;
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            return false;
        }
        String selfName = ManagementFactory.getRuntimeMXBean().getName();
        selfPid = selfName.substring(0, selfName.indexOf(64));
        return true;
    }

    private static Class loadClass(String className) throws ClassNotFoundException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ClassLoader toolsJar = Histogram18.getToolsJar();
            if (toolsJar == null) {
                throw new ClassNotFoundException(className);
            }
            return Class.forName(className, true, toolsJar);
        }
    }
}

